/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwarding.staticrouting.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.forwarding.staticrouting.IForwardingStaticRouting;
import org.opendaylight.controller.forwarding.staticrouting.IStaticRoutingAware;
import org.opendaylight.controller.forwarding.staticrouting.StaticRoute;
import org.opendaylight.controller.forwarding.staticrouting.StaticRouteConfig;
import org.opendaylight.controller.hosttracker.HostIdFactory;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.IfNewHostNotify;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticRoutingImplementation
implements IfNewHostNotify,
IForwardingStaticRouting,
IObjectReader,
IConfigurationContainerAware {
    private static Logger log = LoggerFactory.getLogger(StaticRoutingImplementation.class);
    private static final String STATIC_ROUTES_FILE_NAME = "staticRouting.conf";
    ConcurrentMap<String, StaticRoute> staticRoutes;
    ConcurrentMap<String, StaticRouteConfig> staticRouteConfigs;
    private IfIptoHost hostTracker;
    private Timer gatewayProbeTimer;
    private IClusterContainerServices clusterContainerService = null;
    private IConfigurationContainerService configurationService;
    private Set<IStaticRoutingAware> staticRoutingAware = Collections.synchronizedSet(new HashSet());
    private ExecutorService executor;

    void setStaticRoutingAware(IStaticRoutingAware s) {
        if (this.staticRoutingAware != null) {
            this.staticRoutingAware.add(s);
        }
    }

    void unsetStaticRoutingAware(IStaticRoutingAware s) {
        if (this.staticRoutingAware != null) {
            this.staticRoutingAware.remove(s);
        }
    }

    public void setHostTracker(IfIptoHost hostTracker) {
        log.debug("Setting HostTracker");
        this.hostTracker = hostTracker;
    }

    public void unsetHostTracker(IfIptoHost hostTracker) {
        if (this.hostTracker == hostTracker) {
            this.hostTracker = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    @Override
    public ConcurrentMap<String, StaticRouteConfig> getStaticRouteConfigs() {
        return this.staticRouteConfigs;
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, STATIC_ROUTES_FILE_NAME)) {
            this.addStaticRoute((StaticRouteConfig)conf);
        }
    }

    private Status saveConfig() {
        return this.saveConfigInternal();
    }

    public Status saveConfigInternal() {
        Status status = this.configurationService.persistConfiguration(new ArrayList(this.staticRouteConfigs.values()), STATIC_ROUTES_FILE_NAME);
        if (status.isSuccess()) {
            return status;
        }
        return new Status(StatusCode.INTERNALERROR, "Save failed");
    }

    private void allocateCaches() {
        if (this.clusterContainerService == null) {
            log.trace("un-initialized clusterContainerService, can't create cache");
            return;
        }
        try {
            this.clusterContainerService.createCache("forwarding.staticrouting.routes", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("forwarding.staticrouting.configs", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheExistException cee) {
            log.error("\nCache already exists - destroy and recreate if needed");
        }
        catch (CacheConfigException cce) {
            log.error("\nCache configuration invalid - check cache mode");
        }
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.warn("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        this.staticRoutes = this.clusterContainerService.getCache("forwarding.staticrouting.routes");
        if (this.staticRoutes == null) {
            log.error("\nFailed to get rulesDB handle");
        }
        this.staticRouteConfigs = this.clusterContainerService.getCache("forwarding.staticrouting.configs");
        if (this.staticRouteConfigs == null) {
            log.error("\nFailed to get rulesDB handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStaticRouteUpdate(StaticRoute s, boolean update) {
        if (this.staticRoutingAware != null) {
            log.trace("Invoking StaticRoutingAware listeners");
            Set<IStaticRoutingAware> set = this.staticRoutingAware;
            synchronized (set) {
                for (IStaticRoutingAware ra : this.staticRoutingAware) {
                    try {
                        ra.staticRouteUpdate(s, update);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    private void checkAndUpdateListeners(String name, StaticRoute staticRoute, boolean added) {
        NotifyStaticRouteWorker worker = new NotifyStaticRouteWorker(name, staticRoute, added);
        try {
            this.executor.submit(worker);
        }
        catch (Exception e) {
            log.error("got Exception ", (Throwable)e);
        }
    }

    private void notifyHostUpdate(HostNodeConnector host, boolean added) {
        if (host == null) {
            return;
        }
        for (Map.Entry s : this.staticRoutes.entrySet()) {
            StaticRoute route = (StaticRoute)s.getValue();
            if (route.getType() == StaticRoute.NextHopType.SWITCHPORT || !route.getNextHopAddress().equals(host.getNetworkAddress())) continue;
            if (added) {
                route.setHost(host);
            } else {
                route.setHost(null);
            }
            this.staticRoutes.put((String)s.getKey(), route);
            this.notifyStaticRouteUpdate(route, added);
        }
    }

    public void notifyHTClient(HostNodeConnector host) {
        this.notifyHostUpdate(host, true);
    }

    public void notifyHTClientHostRemoved(HostNodeConnector host) {
        this.notifyHostUpdate(host, false);
    }

    public boolean isIPv4AddressValid(String cidr) {
        int prefix;
        if (cidr == null) {
            return false;
        }
        String[] values = cidr.split("/");
        Pattern ipv4Pattern = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        Matcher mm = ipv4Pattern.matcher(values[0]);
        if (!mm.matches()) {
            log.debug("IPv4 source address {} is not valid", (Object)cidr);
            return false;
        }
        if (values.length >= 2 && ((prefix = Integer.valueOf(values[1]).intValue()) < 0 || prefix > 32)) {
            log.debug("prefix {} is not valid", (Object)prefix);
            return false;
        }
        return true;
    }

    public static short getUnsignedByte(ByteBuffer bb, int position) {
        return (short)(bb.get(position) & 0xFF);
    }

    public static int compareByteBuffers(ByteBuffer buf1, ByteBuffer buf2) {
        for (int i = 0; i < buf1.array().length; ++i) {
            if (StaticRoutingImplementation.getUnsignedByte(buf1, i) > StaticRoutingImplementation.getUnsignedByte(buf2, i)) {
                return 1;
            }
            if (StaticRoutingImplementation.getUnsignedByte(buf1, i) >= StaticRoutingImplementation.getUnsignedByte(buf2, i)) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public StaticRoute getBestMatchStaticRoute(InetAddress ipAddress) {
        ByteBuffer bblongestPrefix = null;
        try {
            bblongestPrefix = ByteBuffer.wrap(InetAddress.getByName("0.0.0.0").getAddress());
        }
        catch (Exception e) {
            return null;
        }
        if (this.staticRoutes == null) {
            return null;
        }
        StaticRoute longestPrefixRoute = null;
        for (StaticRoute s : this.staticRoutes.values()) {
            ByteBuffer bbtmp;
            InetAddress prefix = s.longestPrefixMatch(ipAddress);
            if (prefix == null || !(prefix instanceof Inet4Address) || StaticRoutingImplementation.compareByteBuffers(bbtmp = ByteBuffer.wrap(prefix.getAddress()), bblongestPrefix) <= 0) continue;
            bblongestPrefix = bbtmp;
            longestPrefixRoute = s;
        }
        return longestPrefixRoute;
    }

    @Override
    public Status addStaticRoute(StaticRouteConfig config) {
        Status status = config.isValid();
        if (!status.isSuccess()) {
            return status;
        }
        if (this.staticRouteConfigs.get(config.getName()) != null) {
            return new Status(StatusCode.CONFLICT, "A valid Static Route configuration with this name already exists. Please use a different name");
        }
        StaticRoute sRoute = new StaticRoute(config);
        for (Map.Entry entry : this.staticRoutes.entrySet()) {
            if (((StaticRoute)entry.getValue()).compareTo(sRoute) != 0) continue;
            return new Status(StatusCode.CONFLICT, "This conflicts with an existing Static Route Configuration. Please check the configuration and try again");
        }
        this.staticRoutes.put(config.getName(), sRoute);
        this.staticRouteConfigs.put(config.getName(), config);
        this.checkAndUpdateListeners(config.getName(), sRoute, true);
        return status;
    }

    @Override
    public Status removeStaticRoute(String name) {
        this.staticRouteConfigs.remove(name);
        StaticRoute sRoute = (StaticRoute)this.staticRoutes.remove(name);
        if (sRoute != null) {
            this.checkAndUpdateListeners(name, sRoute, false);
            return new Status(StatusCode.SUCCESS, null);
        }
        return new Status(StatusCode.NOTFOUND, "Static Route with name " + name + " is not found");
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    void init(Component c) {
        String containerName = null;
        Dictionary props = c.getServiceProperties();
        containerName = props != null ? (String)props.get("containerName") : "";
        log.debug("forwarding.staticrouting starting on container {}", (Object)containerName);
        this.allocateCaches();
        this.retrieveCaches();
        this.executor = Executors.newFixedThreadPool(1);
        this.loadConfiguration();
        this.gatewayProbeTimer = new Timer();
        this.gatewayProbeTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (Map.Entry s : StaticRoutingImplementation.this.staticRoutes.entrySet()) {
                    StaticRoute route = (StaticRoute)s.getValue();
                    if (route.getType() != StaticRoute.NextHopType.IPADDRESS || route.getHost() != null) continue;
                    StaticRoutingImplementation.this.checkAndUpdateListeners((String)s.getKey(), route, true);
                }
            }
        }, 60000L, 60000L);
    }

    void destroy() {
        log.debug("Destroy all the Static Routing Rules given we are shutting down");
        this.gatewayProbeTimer.cancel();
        this.staticRoutingAware.clear();
    }

    void start() {
    }

    void stop() {
        this.executor.shutdown();
    }

    public Status saveConfiguration() {
        return this.saveConfig();
    }

    private class NotifyStaticRouteWorker
    implements Callable<Object> {
        private String name;
        private StaticRoute staticRoute;
        private boolean added;

        public NotifyStaticRouteWorker(String name, StaticRoute s, boolean update) {
            this.name = name;
            this.staticRoute = s;
            this.added = update;
        }

        @Override
        public Object call() throws Exception {
            if (!this.added || this.staticRoute.getType() == StaticRoute.NextHopType.SWITCHPORT) {
                StaticRoutingImplementation.this.notifyStaticRouteUpdate(this.staticRoute, this.added);
            } else {
                InetAddress nh = this.staticRoute.getNextHopAddress();
                IHostId id = HostIdFactory.create((InetAddress)nh, null);
                HostNodeConnector host = StaticRoutingImplementation.this.hostTracker.hostQuery(id);
                if (host == null) {
                    log.debug("Next hop {}  is not present, try to discover it", (Object)nh.getHostAddress());
                    Future future = StaticRoutingImplementation.this.hostTracker.discoverHost(id);
                    if (future != null) {
                        try {
                            host = (HostNodeConnector)future.get();
                        }
                        catch (InterruptedException ioe) {
                            log.trace("Thread interrupted {}", (Throwable)ioe);
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                }
                if (host != null) {
                    log.debug("Next hop {} is found", (Object)nh.getHostAddress());
                    this.staticRoute.setHost(host);
                    StaticRoutingImplementation.this.staticRoutes.put(this.name, this.staticRoute);
                    StaticRoutingImplementation.this.notifyStaticRouteUpdate(this.staticRoute, this.added);
                } else {
                    log.debug("Next hop {}  is still not present, try again later", (Object)nh.getHostAddress());
                }
            }
            return null;
        }
    }
}

