/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Drop;
import org.opendaylight.controller.sal.action.Enqueue;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.FloodAll;
import org.opendaylight.controller.sal.action.HwPath;
import org.opendaylight.controller.sal.action.Loopback;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetDlSrc;
import org.opendaylight.controller.sal.action.SetNextHop;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.action.SetNwTos;
import org.opendaylight.controller.sal.action.SetTpDst;
import org.opendaylight.controller.sal.action.SetTpSrc;
import org.opendaylight.controller.sal.action.SetVlanId;
import org.opendaylight.controller.sal.action.SetVlanPcp;
import org.opendaylight.controller.sal.action.SwPath;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FlowConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FlowConfig.class);
    public static final String STATICFLOWGROUP = "__StaticFlows__";
    public static final String INTERNALSTATICFLOWGROUP = "__InternalStaticFlows__";
    public static final String INTERNALSTATICFLOWBEGIN = "__";
    public static final String INTERNALSTATICFLOWEND = "__";
    private boolean dynamic;
    private String status;
    @XmlElement
    private String installInHw;
    @XmlElement
    private String name;
    @XmlElement
    private Node node;
    @XmlElement
    private String ingressPort;
    private String portGroup;
    @XmlElement
    private String priority;
    @XmlElement
    private String etherType;
    @XmlElement
    private String vlanId;
    @XmlElement
    private String vlanPriority;
    @XmlElement
    private String dlSrc;
    @XmlElement
    private String dlDst;
    @XmlElement
    private String nwSrc;
    @XmlElement
    private String nwDst;
    @XmlElement
    private String protocol;
    @XmlElement
    private String tosBits;
    @XmlElement
    private String tpSrc;
    @XmlElement
    private String tpDst;
    @XmlElement
    private String cookie;
    @XmlElement
    private String idleTimeout;
    @XmlElement
    private String hardTimeout;
    @XmlElement
    private List<String> actions;

    public FlowConfig() {
    }

    public FlowConfig(String installInHw, String name, Node node, String priority, String cookie, String ingressPort, String portGroup, String vlanId, String vlanPriority, String etherType, String srcMac, String dstMac, String protocol, String tosBits, String srcIP, String dstIP, String tpSrc, String tpDst, String idleTimeout, String hardTimeout, List<String> actions) {
        this.installInHw = installInHw;
        this.name = name;
        this.node = node;
        this.priority = priority;
        this.cookie = cookie;
        this.ingressPort = ingressPort;
        this.portGroup = portGroup;
        this.vlanId = vlanId;
        this.vlanPriority = vlanPriority;
        this.etherType = etherType;
        this.dlSrc = srcMac;
        this.dlDst = dstMac;
        this.protocol = protocol;
        this.tosBits = tosBits;
        this.nwSrc = srcIP;
        this.nwDst = dstIP;
        this.tpSrc = tpSrc;
        this.tpDst = tpDst;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.actions = actions;
        this.status = StatusCode.SUCCESS.toString();
    }

    public FlowConfig(FlowConfig from) {
        this.installInHw = from.installInHw;
        this.name = from.name;
        this.node = from.node;
        this.priority = from.priority;
        this.cookie = from.cookie;
        this.ingressPort = from.ingressPort;
        this.portGroup = from.portGroup;
        this.vlanId = from.vlanId;
        this.vlanPriority = from.vlanPriority;
        this.etherType = from.etherType;
        this.dlSrc = from.dlSrc;
        this.dlDst = from.dlDst;
        this.protocol = from.protocol;
        this.tosBits = from.tosBits;
        this.nwSrc = from.nwSrc;
        this.nwDst = from.nwDst;
        this.tpSrc = from.tpSrc;
        this.tpDst = from.tpDst;
        this.idleTimeout = from.idleTimeout;
        this.hardTimeout = from.hardTimeout;
        this.actions = new ArrayList<String>(from.actions);
    }

    public boolean installInHw() {
        if (this.installInHw == null) {
            this.installInHw = Boolean.toString(true);
        }
        return Boolean.valueOf(this.installInHw);
    }

    public void setInstallInHw(boolean inHw) {
        this.installInHw = String.valueOf(inHw);
    }

    public String getInstallInHw() {
        return this.installInHw;
    }

    public boolean isInternalFlow() {
        return this.name != null && this.name.startsWith("__") && this.name.endsWith("__");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getIngressPort() {
        return this.ingressPort;
    }

    public void setIngressPort(String ingressPort) {
        this.ingressPort = ingressPort;
    }

    public String getPortGroup() {
        return this.portGroup;
    }

    public String toString() {
        return "FlowConfig [dynamic=" + this.dynamic + ", status=" + this.status + ", installInHw=" + this.installInHw + ", name=" + this.name + ", switchId=" + this.node + ", ingressPort=" + this.ingressPort + ", portGroup=" + this.portGroup + ", etherType=" + this.etherType + ", priority=" + this.priority + ", vlanId=" + this.vlanId + ", vlanPriority=" + this.vlanPriority + ", dlSrc=" + this.dlSrc + ", dlDst=" + this.dlDst + ", nwSrc=" + this.nwSrc + ", nwDst=" + this.nwDst + ", protocol=" + this.protocol + ", tosBits=" + this.tosBits + ", tpSrc=" + this.tpSrc + ", tpDst=" + this.tpDst + ", cookie=" + this.cookie + ", idleTimeout=" + this.idleTimeout + ", hardTimeout=" + this.hardTimeout + ", actions=" + this.actions + "]";
    }

    public void setPortGroup(String portGroup) {
        this.portGroup = portGroup;
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public void setVlanId(String vlanId) {
        this.vlanId = vlanId;
    }

    public String getVlanPriority() {
        return this.vlanPriority;
    }

    public void setVlanPriority(String vlanPriority) {
        this.vlanPriority = vlanPriority;
    }

    public String getEtherType() {
        return this.etherType;
    }

    public void setEtherType(String etherType) {
        this.etherType = etherType;
    }

    public String getSrcMac() {
        return this.dlSrc;
    }

    public void setSrcMac(String srcMac) {
        this.dlSrc = srcMac;
    }

    public String getDstMac() {
        return this.dlDst;
    }

    public void setDstMac(String dstMac) {
        this.dlDst = dstMac;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getTosBits() {
        return this.tosBits;
    }

    public void setTosBits(String tos_bits) {
        this.tosBits = tos_bits;
    }

    public String getSrcIp() {
        return this.nwSrc;
    }

    public void setSrcIp(String src_ip) {
        this.nwSrc = src_ip;
    }

    public String getDstIp() {
        return this.nwDst;
    }

    public void setDstIp(String dst_ip) {
        this.nwDst = dst_ip;
    }

    public String getSrcPort() {
        return this.tpSrc;
    }

    public void setSrcPort(String src_port) {
        this.tpSrc = src_port;
    }

    public String getDstPort() {
        return this.tpDst;
    }

    public void setDstPort(String dst_port) {
        this.tpDst = dst_port;
    }

    public String getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getHardTimeout() {
        return this.hardTimeout;
    }

    public void setHardTimeout(String hardTimeout) {
        this.hardTimeout = hardTimeout;
    }

    public boolean isIPv6() {
        return NetUtils.isIPv6AddressValid((String)this.getSrcIp()) || NetUtils.isIPv6AddressValid((String)this.getDstIp());
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public boolean isPortGroupEnabled() {
        return this.portGroup != null;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isStatusSuccessful() {
        return this.status.equals(StatusCode.SUCCESS.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.dlDst == null ? 0 : this.dlDst.hashCode());
        result = 31 * result + (this.dlSrc == null ? 0 : this.dlSrc.hashCode());
        result = 31 * result + (this.dynamic ? 1231 : 1237);
        result = 31 * result + (this.etherType == null ? 0 : this.etherType.hashCode());
        result = 31 * result + (this.ingressPort == null ? 0 : this.ingressPort.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nwDst == null ? 0 : this.nwDst.hashCode());
        result = 31 * result + (this.nwSrc == null ? 0 : this.nwSrc.hashCode());
        result = 31 * result + (this.portGroup == null ? 0 : this.portGroup.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.tosBits == null ? 0 : this.tosBits.hashCode());
        result = 31 * result + (this.tpDst == null ? 0 : this.tpDst.hashCode());
        result = 31 * result + (this.tpSrc == null ? 0 : this.tpSrc.hashCode());
        result = 31 * result + (this.vlanId == null ? 0 : this.vlanId.hashCode());
        result = 31 * result + (this.vlanPriority == null ? 0 : this.vlanPriority.hashCode());
        result = 31 * result + (this.idleTimeout == null ? 0 : this.idleTimeout.hashCode());
        result = 31 * result + (this.hardTimeout == null ? 0 : this.hardTimeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowConfig other = (FlowConfig)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.dlDst == null ? other.dlDst != null : !this.dlDst.equals(other.dlDst)) {
            return false;
        }
        if (this.dlSrc == null ? other.dlSrc != null : !this.dlSrc.equals(other.dlSrc)) {
            return false;
        }
        if (this.dynamic != other.dynamic) {
            return false;
        }
        if (this.etherType == null ? other.etherType != null : !this.etherType.equals(other.etherType)) {
            return false;
        }
        if (this.ingressPort == null ? other.ingressPort != null : !this.ingressPort.equals(other.ingressPort)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nwDst == null ? other.nwDst != null : !this.nwDst.equals(other.nwDst)) {
            return false;
        }
        if (this.nwSrc == null ? other.nwSrc != null : !this.nwSrc.equals(other.nwSrc)) {
            return false;
        }
        if (this.portGroup == null ? other.portGroup != null : !this.portGroup.equals(other.portGroup)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.node == null ? other.node != null : !this.node.equals((Object)other.node)) {
            return false;
        }
        if (this.tosBits == null ? other.tosBits != null : !this.tosBits.equals(other.tosBits)) {
            return false;
        }
        if (this.tpDst == null ? other.tpDst != null : !this.tpDst.equals(other.tpDst)) {
            return false;
        }
        if (this.tpSrc == null ? other.tpSrc != null : !this.tpSrc.equals(other.tpSrc)) {
            return false;
        }
        if (this.vlanId == null ? other.vlanId != null : !this.vlanId.equals(other.vlanId)) {
            return false;
        }
        if (this.vlanPriority == null ? other.vlanPriority != null : !this.vlanPriority.equals(other.vlanPriority)) {
            return false;
        }
        if (this.idleTimeout == null ? other.idleTimeout != null : !this.idleTimeout.equals(other.idleTimeout)) {
            return false;
        }
        return !(this.hardTimeout == null ? other.hardTimeout != null : !this.hardTimeout.equals(other.hardTimeout));
    }

    public boolean isL2AddressValid(String mac) {
        if (mac == null) {
            return false;
        }
        Pattern macPattern = Pattern.compile("([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2}");
        Matcher mm = macPattern.matcher(mac);
        if (!mm.matches()) {
            log.debug("Ethernet address {} is not valid. Example: 00:05:b9:7c:81:5f", (Object)mac);
            return false;
        }
        return true;
    }

    public boolean isVlanIdValid(String vlanId) {
        int vlan = Integer.decode(vlanId);
        return vlan >= 0 && vlan < 4096;
    }

    public boolean isVlanPriorityValid(String vlanPriority) {
        int pri = Integer.decode(vlanPriority);
        return pri >= 0 && pri < 8;
    }

    public boolean isTOSBitsValid(String tosBits) {
        int tos = Integer.decode(tosBits);
        return tos >= 0 && tos < 64;
    }

    public boolean isTpPortValid(String tpPort) {
        int port = Integer.decode(tpPort);
        return port >= 0 && port <= 65535;
    }

    public boolean isTimeoutValid(String timeout) {
        int to = Integer.decode(timeout);
        return to >= 0 && to <= 65535;
    }

    public boolean isProtocolValid(String protocol) {
        IPProtocols proto = IPProtocols.fromString((String)protocol);
        return proto != null;
    }

    public Status validate() {
        EtherIPType etype = EtherIPType.ANY;
        EtherIPType ipsrctype = EtherIPType.ANY;
        EtherIPType ipdsttype = EtherIPType.ANY;
        try {
            if (!this.isValidResourceName(this.name) || this.isInternalFlow()) {
                return new Status(StatusCode.BADREQUEST, "Invalid name");
            }
            if (this.node == null) {
                return new Status(StatusCode.BADREQUEST, "Node is null");
            }
            if (this.priority != null && (Integer.decode(this.priority) < 0 || Integer.decode(this.priority) > 65535)) {
                return new Status(StatusCode.BADREQUEST, String.format("priority %s is not in the range 0 - 65535", this.priority));
            }
            if (this.cookie != null) {
                Long.decode(this.cookie);
            }
            if (this.ingressPort != null && this.ingressPort.isEmpty()) {
                return new Status(StatusCode.BADREQUEST, "Invalid ingress port");
            }
            if (this.vlanId != null && !this.isVlanIdValid(this.vlanId)) {
                return new Status(StatusCode.BADREQUEST, String.format("Vlan ID %s is not in the range 0 - 4095", this.vlanId));
            }
            if (this.vlanPriority != null && !this.isVlanPriorityValid(this.vlanPriority)) {
                return new Status(StatusCode.BADREQUEST, String.format("Vlan priority %s is not in the range 0 - 7", this.vlanPriority));
            }
            if (this.etherType != null) {
                int type = Integer.decode(this.etherType);
                if (type < 0 || type > 65535) {
                    return new Status(StatusCode.BADREQUEST, String.format("Ethernet type %s is not valid", this.etherType));
                }
                if (type == 2048) {
                    etype = EtherIPType.V4;
                } else if (type == 34525) {
                    etype = EtherIPType.V6;
                }
            }
            if (this.protocol != null && !this.isProtocolValid(this.protocol)) {
                return new Status(StatusCode.BADREQUEST, String.format("Protocol %s is not valid", this.protocol));
            }
            if (this.tosBits != null && !this.isTOSBitsValid(this.tosBits)) {
                return new Status(StatusCode.BADREQUEST, String.format("IP ToS bits %s is not in the range 0 - 63", this.tosBits));
            }
            if (this.tpSrc != null && !this.isTpPortValid(this.tpSrc)) {
                return new Status(StatusCode.BADREQUEST, String.format("Transport source port %s is not valid", this.tpSrc));
            }
            if (this.tpDst != null && !this.isTpPortValid(this.tpDst)) {
                return new Status(StatusCode.BADREQUEST, String.format("Transport destination port %s is not valid", this.tpDst));
            }
            if (this.dlSrc != null && !this.isL2AddressValid(this.dlSrc)) {
                return new Status(StatusCode.BADREQUEST, String.format("Ethernet source address %s is not valid. Example: 00:05:b9:7c:81:5f", this.dlSrc));
            }
            if (this.dlDst != null && !this.isL2AddressValid(this.dlDst)) {
                return new Status(StatusCode.BADREQUEST, String.format("Ethernet destination address %s is not valid. Example: 00:05:b9:7c:81:5f", this.dlDst));
            }
            if (this.nwSrc != null) {
                if (NetUtils.isIPv4AddressValid((String)this.nwSrc)) {
                    ipsrctype = EtherIPType.V4;
                } else if (NetUtils.isIPv6AddressValid((String)this.nwSrc)) {
                    ipsrctype = EtherIPType.V6;
                } else {
                    return new Status(StatusCode.BADREQUEST, String.format("IP source address %s is not valid", this.nwSrc));
                }
            }
            if (this.nwDst != null) {
                if (NetUtils.isIPv4AddressValid((String)this.nwDst)) {
                    ipdsttype = EtherIPType.V4;
                } else if (NetUtils.isIPv6AddressValid((String)this.nwDst)) {
                    ipdsttype = EtherIPType.V6;
                } else {
                    return new Status(StatusCode.BADREQUEST, String.format("IP destination address %s is not valid", this.nwDst));
                }
            }
            if (etype != EtherIPType.ANY) {
                if (ipsrctype != EtherIPType.ANY && ipsrctype != etype) {
                    return new Status(StatusCode.BADREQUEST, String.format("Type mismatch between Ethernet & Src IP", new Object[0]));
                }
                if (ipdsttype != EtherIPType.ANY && ipdsttype != etype) {
                    return new Status(StatusCode.BADREQUEST, String.format("Type mismatch between Ethernet & Dst IP", new Object[0]));
                }
            }
            if (ipsrctype != ipdsttype && ipsrctype != EtherIPType.ANY && ipdsttype != EtherIPType.ANY) {
                return new Status(StatusCode.BADREQUEST, String.format("IP Src Dest Type mismatch", new Object[0]));
            }
            if (this.idleTimeout != null && !this.isTimeoutValid(this.idleTimeout)) {
                return new Status(StatusCode.BADREQUEST, String.format("Idle Timeout value %s is not valid", this.idleTimeout));
            }
            if (this.hardTimeout != null && !this.isTimeoutValid(this.hardTimeout)) {
                return new Status(StatusCode.BADREQUEST, String.format("Hard Timeout value %s is not valid", this.hardTimeout));
            }
            if (this.actions == null || this.actions.isEmpty()) {
                return new Status(StatusCode.BADREQUEST, "Actions value is null or empty");
            }
            for (String actiongrp : this.actions) {
                Matcher sstr = Pattern.compile(ActionType.SET_NW_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (NetUtils.isIPv4AddressValid((String)sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("IP source address %s is not valid", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_NW_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (NetUtils.isIPv4AddressValid((String)sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("IP destination address %s is not valid", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_VLAN_ID.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isVlanIdValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Vlan ID %s is not in the range 0 - 4095", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.ENQUEUE + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    for (String t : sstr.group(1).split(",")) {
                        if (t == null) continue;
                        String[] parts = t.split(":");
                        String nc = String.format("%s|%s@%s", this.node.getType(), parts[0], this.node.toString());
                        if (NodeConnector.fromString((String)nc) == null) {
                            return new Status(StatusCode.BADREQUEST, String.format("Enqueue port is not valid", new Object[0]));
                        }
                        if (parts.length <= 1) continue;
                        try {
                            Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException e) {
                            return new Status(StatusCode.BADREQUEST, String.format("Enqueue %s is not in the range 0 - 2147483647", parts[1]));
                        }
                    }
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_VLAN_PCP.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isVlanPriorityValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Vlan priority %s is not in the range 0 - 7", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_DL_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isL2AddressValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Ethernet source address %s is not valid. Example: 00:05:b9:7c:81:5f", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_DL_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isL2AddressValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Ethernet destination address %s is not valid. Example: 00:05:b9:7c:81:5f", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_NW_TOS.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isTOSBitsValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("IP ToS bits %s is not in the range 0 - 63", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_TP_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isTpPortValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Transport source port %s is not valid", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_TP_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (sstr.group(1) == null || this.isTpPortValid(sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Transport destination port %s is not valid", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.SET_NEXT_HOP.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    if (NetUtils.isIPAddressValid((String)sstr.group(1))) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("IP destination address %s is not valid", sstr.group(1)));
                }
                sstr = Pattern.compile(ActionType.OUTPUT + "=(.*)").matcher(actiongrp);
                if (sstr.matches() || (sstr = Pattern.compile(ActionType.DROP.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.LOOPBACK.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.FLOOD.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.FLOOD_ALL.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.SW_PATH.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.HW_PATH.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.CONTROLLER.toString()).matcher(actiongrp)).matches() || (sstr = Pattern.compile(ActionType.POP_VLAN.toString()).matcher(actiongrp)).matches()) continue;
                return new Status(StatusCode.BADREQUEST, String.format("%s is an UnSupported Action", actiongrp));
            }
        }
        catch (NumberFormatException e) {
            return new Status(StatusCode.BADREQUEST, String.format("Invalid number format %s", e.getMessage()));
        }
        return new Status(StatusCode.SUCCESS);
    }

    public FlowEntry getFlowEntry() {
        String group = this.isInternalFlow() ? INTERNALSTATICFLOWGROUP : STATICFLOWGROUP;
        return new FlowEntry(group, this.name, this.getFlow(), this.getNode());
    }

    public Flow getFlow() {
        int maskLen;
        InetAddress mask;
        InetAddress ip;
        String[] parts;
        Match match = new Match();
        if (this.ingressPort != null) {
            match.setField(MatchType.IN_PORT, (Object)NodeConnector.fromString((String)String.format("%s|%s@%s", this.node.getType(), this.ingressPort, this.node.toString())));
        }
        if (this.dlSrc != null) {
            match.setField(MatchType.DL_SRC, (Object)HexEncode.bytesFromHexString((String)this.dlSrc));
        }
        if (this.dlDst != null) {
            match.setField(MatchType.DL_DST, (Object)HexEncode.bytesFromHexString((String)this.dlDst));
        }
        if (this.etherType != null) {
            match.setField(MatchType.DL_TYPE, (Object)Integer.decode(this.etherType).shortValue());
        }
        if (this.vlanId != null) {
            match.setField(MatchType.DL_VLAN, (Object)Short.parseShort(this.vlanId));
        }
        if (this.vlanPriority != null) {
            match.setField(MatchType.DL_VLAN_PR, (Object)Byte.parseByte(this.vlanPriority));
        }
        if (this.nwSrc != null) {
            parts = this.nwSrc.split("/");
            ip = NetUtils.parseInetAddress((String)parts[0]);
            mask = null;
            maskLen = 0;
            maskLen = parts.length > 1 ? Integer.parseInt(parts[1]) : (ip instanceof Inet6Address ? 128 : 32);
            mask = NetUtils.getInetNetworkMask((int)maskLen, (boolean)(ip instanceof Inet6Address));
            match.setField(MatchType.NW_SRC, (Object)ip, (Object)mask);
        }
        if (this.nwDst != null) {
            parts = this.nwDst.split("/");
            ip = NetUtils.parseInetAddress((String)parts[0]);
            mask = null;
            maskLen = 0;
            maskLen = parts.length > 1 ? Integer.parseInt(parts[1]) : (ip instanceof Inet6Address ? 128 : 32);
            mask = NetUtils.getInetNetworkMask((int)maskLen, (boolean)(ip instanceof Inet6Address));
            match.setField(MatchType.NW_DST, (Object)ip, (Object)mask);
        }
        if (IPProtocols.fromString((String)this.protocol) != IPProtocols.ANY) {
            match.setField(MatchType.NW_PROTO, (Object)IPProtocols.getProtocolNumberByte((String)this.protocol));
        }
        if (this.tosBits != null) {
            match.setField(MatchType.NW_TOS, (Object)Byte.parseByte(this.tosBits));
        }
        if (this.tpSrc != null) {
            match.setField(MatchType.TP_SRC, (Object)Integer.valueOf(this.tpSrc).shortValue());
        }
        if (this.tpDst != null) {
            match.setField(MatchType.TP_DST, (Object)Integer.valueOf(this.tpDst).shortValue());
        }
        Flow flow = new Flow(match, this.getActionList());
        if (this.cookie != null) {
            flow.setId(Long.parseLong(this.cookie));
        }
        if (this.hardTimeout != null) {
            flow.setHardTimeout(Short.parseShort(this.hardTimeout));
        }
        if (this.idleTimeout != null) {
            flow.setIdleTimeout(Short.parseShort(this.idleTimeout));
        }
        if (this.priority != null) {
            flow.setPriority(Integer.decode(this.priority).shortValue());
        }
        return flow;
    }

    public boolean isByNameAndNodeIdEqual(FlowConfig that) {
        return this.name.equals(that.name) && this.node.equals((Object)that.node);
    }

    public boolean isByNameAndNodeIdEqual(String name, Node node) {
        return this.name.equals(name) && this.node.equals((Object)node);
    }

    public boolean onNode(Node node) {
        return this.node.equals((Object)node);
    }

    public void toggleInstallation() {
        this.installInHw = this.installInHw == null ? Boolean.toString(false) : Boolean.toString(Boolean.valueOf(this.installInHw) == false);
    }

    private List<Action> getActionList() {
        ArrayList<Action> actionList = new ArrayList<Action>();
        if (this.actions != null) {
            for (String actiongrp : this.actions) {
                Matcher sstr = Pattern.compile(ActionType.OUTPUT + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    for (String t : sstr.group(1).split(",")) {
                        if (t == null) continue;
                        String nc = String.format("%s|%s@%s", this.node.getType(), t, this.node.toString());
                        actionList.add((Action)new Output(NodeConnector.fromString((String)nc)));
                    }
                    continue;
                }
                sstr = Pattern.compile(ActionType.ENQUEUE + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    for (String t : sstr.group(1).split(",")) {
                        if (t == null) continue;
                        String[] parts = t.split(":");
                        String nc = String.format("%s|%s@%s", this.node.getType(), parts[0], this.node.toString());
                        if (parts.length == 1) {
                            actionList.add((Action)new Enqueue(NodeConnector.fromString((String)nc)));
                            continue;
                        }
                        actionList.add((Action)new Enqueue(NodeConnector.fromString((String)nc), Integer.parseInt(parts[1])));
                    }
                    continue;
                }
                sstr = Pattern.compile(ActionType.DROP.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new Drop());
                    continue;
                }
                sstr = Pattern.compile(ActionType.LOOPBACK.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new Loopback());
                    continue;
                }
                sstr = Pattern.compile(ActionType.FLOOD.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new Flood());
                    continue;
                }
                sstr = Pattern.compile(ActionType.FLOOD_ALL.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new FloodAll());
                    continue;
                }
                sstr = Pattern.compile(ActionType.SW_PATH.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SwPath());
                    continue;
                }
                sstr = Pattern.compile(ActionType.HW_PATH.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new HwPath());
                    continue;
                }
                sstr = Pattern.compile(ActionType.CONTROLLER.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new Controller());
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_VLAN_ID.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetVlanId((int)Short.parseShort(sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_VLAN_PCP.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetVlanPcp((int)Byte.parseByte(sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.POP_VLAN.toString()).matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new PopVlan());
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_DL_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetDlSrc(HexEncode.bytesFromHexString((String)sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_DL_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetDlDst(HexEncode.bytesFromHexString((String)sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_NW_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetNwSrc(NetUtils.parseInetAddress((String)sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_NW_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetNwDst(NetUtils.parseInetAddress((String)sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_NW_TOS.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetNwTos((int)Byte.parseByte(sstr.group(1))));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_TP_SRC.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetTpSrc(Integer.valueOf(sstr.group(1)).intValue()));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_TP_DST.toString() + "=(.*)").matcher(actiongrp);
                if (sstr.matches()) {
                    actionList.add((Action)new SetTpDst(Integer.valueOf(sstr.group(1)).intValue()));
                    continue;
                }
                sstr = Pattern.compile(ActionType.SET_NEXT_HOP.toString() + "=(.*)").matcher(actiongrp);
                if (!sstr.matches()) continue;
                actionList.add((Action)new SetNextHop(NetUtils.parseInetAddress((String)sstr.group(1))));
            }
        }
        return actionList;
    }

    private static enum EtherIPType {
        ANY,
        V4,
        V6;

    }
}

