/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager;

import java.io.Serializable;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Node;

public class FlowEntryInstall
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FlowEntry original;
    private final ContainerFlow cFlow;
    private final FlowEntry install;
    private transient long requestId;
    private transient boolean deletePending;

    public FlowEntryInstall(FlowEntry original, ContainerFlow cFlow) {
        this.original = original;
        this.cFlow = cFlow;
        this.install = cFlow == null ? original.clone() : original.clone().mergeWith(cFlow);
        this.deletePending = false;
        this.requestId = 0L;
    }

    public int hashCode() {
        return this.install.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowEntryInstall other = (FlowEntryInstall)obj;
        return !(this.install == null ? other.install != null : !this.install.equals(other.install));
    }

    public String getFlowName() {
        return this.original.getFlowName();
    }

    public String getGroupName() {
        return this.original.getGroupName();
    }

    public Node getNode() {
        return this.original.getNode();
    }

    public boolean equalsByNodeAndName(Node node, String flowName) {
        return this.original.equalsByNodeAndName(node, flowName);
    }

    public FlowEntry getOriginal() {
        return this.original;
    }

    public ContainerFlow getContainerFlow() {
        return this.cFlow;
    }

    public FlowEntry getInstall() {
        return this.install;
    }

    public boolean isDeletePending() {
        return this.deletePending;
    }

    public void toBeDeleted() {
        this.deletePending = true;
    }

    public void setRequestId(long rid) {
        this.requestId = rid;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public String toString() {
        return "[Install = " + this.install + " Original = " + this.original + " cFlow = " + this.cFlow + " rid = " + this.requestId + "]";
    }
}

