/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager;

import java.io.Serializable;
import java.util.Date;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowEntry
implements Cloneable,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(FlowEntry.class);
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FlowEntry.class);
    private String groupName;
    private String flowName;
    private Node node;
    private Flow flow;

    public FlowEntry(String groupName, String flowName, Flow flow, Node node) {
        this.groupName = groupName;
        this.flow = flow;
        this.node = node;
        this.flowName = flowName != null ? flowName : this.constructFlowName();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node n) {
        this.node = n;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String n) {
        this.flowName = n;
    }

    public FlowEntry clone() {
        FlowEntry cloned = null;
        try {
            cloned = (FlowEntry)super.clone();
            cloned.flow = this.flow.clone();
        }
        catch (CloneNotSupportedException e) {
            log.warn("exception in clone", (Throwable)e);
        }
        return cloned;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.flow == null ? 0 : (int)this.flow.getPriority());
        result = 31 * result + (this.flow == null || this.flow.getMatch() == null ? 0 : this.flow.getMatch().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowEntry other = (FlowEntry)obj;
        if (this.node == null ? other.node != null : !this.node.equals((Object)other.node)) {
            return false;
        }
        if (this.flow == null) {
            return other.flow == null;
        }
        if (other.flow == null) {
            return false;
        }
        if (this.flow.getPriority() != other.flow.getPriority()) {
            return false;
        }
        return !(this.flow.getMatch() == null ? other.flow.getMatch() != null : !this.flow.getMatch().equals((Object)other.flow.getMatch()));
    }

    public String toString() {
        return "FlowEntry[flowName = " + this.flowName + ", groupName = " + this.groupName + ", node = " + this.node + ", flow = " + this.flow + "]";
    }

    private String constructFlowName() {
        return this.groupName + "_" + new Date().toString();
    }

    public boolean equalsByNodeAndName(Node node, String flowName) {
        return this.node.equals((Object)node) && this.flowName.equals(flowName);
    }

    public FlowEntry mergeWith(ContainerFlow containerFlow) {
        Match myMatch = this.flow.getMatch();
        Match filter = containerFlow.getMatch();
        Match merge = myMatch.mergeWithFilter(filter);
        this.flow.setMatch(merge);
        return this;
    }

    public boolean isInternal() {
        return this.flowName.startsWith("__") && this.flowName.endsWith("__");
    }
}

