/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import java.util.ArrayList;
import java.util.List;

public enum EtherTypes {
    PVSTP("PVSTP", 267),
    CDP("CDP", 8192),
    VTP("VTP", 8195),
    IPv4("IPv4", 2048),
    ARP("ARP", 2054),
    RARP("Reverse ARP", 32821),
    VLANTAGGED("VLAN Tagged", 33024),
    IPv6("IPv6", 34525),
    MPLSUCAST("MPLS Unicast", 34887),
    MPLSMCAST("MPLS Multicast", 34888),
    QINQ("QINQ", 34984),
    LLDP("LLDP", 35020),
    OLDQINQ("Old QINQ", 37120),
    CISCOQINQ("Cisco QINQ", 37376);

    private static final String regexNumberString = "^[0-9]+$";
    private String description;
    private int number;

    private EtherTypes(String description, int number) {
        this.description = description;
        this.number = number;
    }

    public String toString() {
        return this.description;
    }

    public int intValue() {
        return this.number;
    }

    public short shortValue() {
        return Integer.valueOf(this.number).shortValue();
    }

    public static String getEtherTypeName(int number) {
        return EtherTypes.getEtherTypeInternal(number);
    }

    public static String getEtherTypeName(short number) {
        return EtherTypes.getEtherTypeInternal(number & 0xFFFF);
    }

    public static String getEtherTypeName(byte number) {
        return EtherTypes.getEtherTypeInternal(number & 0xFF);
    }

    private static String getEtherTypeInternal(int number) {
        for (EtherTypes type : EtherTypes.values()) {
            if (type.number != number) continue;
            return type.toString();
        }
        return "0x" + Integer.toHexString(number);
    }

    public static short getEtherTypeNumberShort(String name) {
        if (name.matches(regexNumberString)) {
            return Short.valueOf(name);
        }
        for (EtherTypes type : EtherTypes.values()) {
            if (!type.description.equalsIgnoreCase(name)) continue;
            return type.shortValue();
        }
        return 0;
    }

    public static int getEtherTypeNumberInt(String name) {
        if (name.matches(regexNumberString)) {
            return Integer.valueOf(name);
        }
        for (EtherTypes type : EtherTypes.values()) {
            if (!type.description.equalsIgnoreCase(name)) continue;
            return type.intValue();
        }
        return 0;
    }

    public static List<String> getEtherTypesNameList() {
        ArrayList<String> ethertypesList = new ArrayList<String>();
        for (EtherTypes type : EtherTypes.values()) {
            ethertypesList.add(type.toString());
        }
        return ethertypesList;
    }

    public static EtherTypes loadFromString(String string) {
        int intType = Integer.parseInt(string);
        for (EtherTypes type : EtherTypes.values()) {
            if (type.number != intType) continue;
            return type;
        }
        return null;
    }
}

