/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.liblldp.BitBufferHelper;
import org.opendaylight.controller.liblldp.EtherTypes;
import org.opendaylight.controller.liblldp.LLDP;
import org.opendaylight.controller.liblldp.NetUtils;
import org.opendaylight.controller.liblldp.Packet;

public class Ethernet
extends Packet {
    private static final String DMAC = "DestinationMACAddress";
    private static final String SMAC = "SourceMACAddress";
    private static final String ETHT = "EtherType";
    public static final Map<Short, Class<? extends Packet>> etherTypeClassMap = new HashMap<Short, Class<? extends Packet>>();
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates;
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public Ethernet() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public Ethernet(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        if (headerField.equals(ETHT)) {
            this.payloadClass = etherTypeClassMap.get(BitBufferHelper.getShort(readValue));
        }
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public byte[] getDestinationMACAddress() {
        return this.fieldValues.get(DMAC);
    }

    public byte[] getSourceMACAddress() {
        return this.fieldValues.get(SMAC);
    }

    public short getEtherType() {
        return BitBufferHelper.getShort(this.fieldValues.get(ETHT));
    }

    public boolean isBroadcast() {
        return NetUtils.isBroadcastMACAddr(this.getDestinationMACAddress());
    }

    public boolean isMulticast() {
        return NetUtils.isMulticastMACAddr(this.getDestinationMACAddress());
    }

    public Ethernet setDestinationMACAddress(byte[] destinationMACAddress) {
        this.fieldValues.put(DMAC, destinationMACAddress);
        return this;
    }

    public Ethernet setSourceMACAddress(byte[] sourceMACAddress) {
        this.fieldValues.put(SMAC, sourceMACAddress);
        return this;
    }

    public Ethernet setEtherType(short etherType) {
        byte[] ethType = BitBufferHelper.toByteArray(etherType);
        this.fieldValues.put(ETHT, ethType);
        return this;
    }

    static {
        etherTypeClassMap.put(EtherTypes.LLDP.shortValue(), LLDP.class);
        fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Ethernet.DMAC, new ImmutablePair((Object)0, (Object)48));
                this.put(Ethernet.SMAC, new ImmutablePair((Object)48, (Object)48));
                this.put(Ethernet.ETHT, new ImmutablePair((Object)96, (Object)16));
            }
        };
    }
}

