/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opendaylight.controller.liblldp.ConstructionException;
import org.opendaylight.controller.liblldp.DataLinkAddress;
import org.opendaylight.controller.liblldp.HexEncode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class EthernetAddress
extends DataLinkAddress {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private byte[] macAddress;
    public static final EthernetAddress BROADCASTMAC;
    public static final EthernetAddress INVALIDHOST;
    public static final String addressName = "Ethernet MAC Address";
    public static final int SIZE = 6;

    private static final EthernetAddress createWellKnownAddress(byte[] mac) {
        try {
            return new EthernetAddress(mac);
        }
        catch (ConstructionException ce) {
            return null;
        }
    }

    private EthernetAddress() {
    }

    public EthernetAddress(byte[] macAddress) throws ConstructionException {
        super(addressName);
        if (macAddress == null) {
            throw new ConstructionException("Null input parameter passed");
        }
        if (macAddress.length != 6) {
            throw new ConstructionException("Wrong size of passed byte array, expected:6 got:" + macAddress.length);
        }
        this.macAddress = new byte[6];
        System.arraycopy(macAddress, 0, this.macAddress, 0, 6);
    }

    @Override
    public EthernetAddress clone() {
        try {
            return new EthernetAddress((byte[])this.macAddress.clone());
        }
        catch (ConstructionException ce) {
            return null;
        }
    }

    public byte[] getValue() {
        return this.macAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.macAddress);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EthernetAddress other = (EthernetAddress)obj;
        return Arrays.equals(this.macAddress, other.macAddress);
    }

    @Override
    public String toString() {
        return "EthernetAddress [macAddress=" + HexEncode.bytesToHexStringFormat(this.macAddress) + "]";
    }

    @XmlElement(name="macAddress")
    public String getMacAddress() {
        return HexEncode.bytesToHexStringFormat(this.macAddress);
    }

    static {
        INVALIDHOST = BROADCASTMAC = EthernetAddress.createWellKnownAddress(new byte[]{-1, -1, -1, -1, -1, -1});
    }
}

