/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import java.math.BigInteger;

public class HexEncode {
    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            short u8byte = (short)(bytes[i] & 0xFF);
            String tmp = Integer.toHexString(u8byte);
            if (tmp.length() == 1) {
                buf.append("0");
            }
            buf.append(tmp);
        }
        return buf.toString();
    }

    public static String longToHexString(long val) {
        int i;
        char[] arr = Long.toHexString(val).toCharArray();
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < 16 - arr.length; ++i) {
            buf.append("0");
            if ((i & 1) != 1) continue;
            buf.append(":");
        }
        for (int j = 0; j < arr.length; ++j) {
            buf.append(arr[j]);
            if ((i + j & 1) != 1 || j >= arr.length - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public static byte[] bytesFromHexString(String values) {
        String target = "";
        if (values != null) {
            target = values;
        }
        String[] octets = target.split(":");
        byte[] ret = new byte[octets.length];
        for (int i = 0; i < octets.length; ++i) {
            ret[i] = Integer.valueOf(octets[i], 16).byteValue();
        }
        return ret;
    }

    public static long stringToLong(String values) {
        long value = new BigInteger(values.replaceAll(":", ""), 16).longValue();
        return value;
    }

    public static String bytesToHexStringFormat(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            short u8byte;
            String tmp;
            if (i > 0) {
                buf.append(":");
            }
            if ((tmp = Integer.toHexString(u8byte = (short)(bytes[i] & 0xFF))).length() == 1) {
                buf.append("0");
            }
            buf.append(tmp);
        }
        return buf.toString();
    }
}

