/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.liblldp.BitBufferHelper;
import org.opendaylight.controller.liblldp.BufferException;
import org.opendaylight.controller.liblldp.CustomTLVKey;
import org.opendaylight.controller.liblldp.HexEncode;
import org.opendaylight.controller.liblldp.LLDPTLV;
import org.opendaylight.controller.liblldp.Packet;
import org.opendaylight.controller.liblldp.PacketException;

public class LLDP
extends Packet {
    private static final String CHASSISID = "ChassisId";
    private static final String SYSTEMNAMEID = "SystemNameID";
    private static final String PORTID = "PortId";
    private static final String TTL = "TTL";
    private static final int LLDPDefaultTlvs = 3;
    private static final LLDPTLV emptyTLV = new LLDPTLV().setLength((short)0).setType((byte)0);
    public static final byte[] LLDPMulticastMac = new byte[]{1, -128, -62, 0, 0, 14};
    private Map<Byte, LLDPTLV> mandatoryTLVs;
    private Map<Byte, LLDPTLV> optionalTLVs;
    private Map<CustomTLVKey, LLDPTLV> customTLVs;

    public LLDP() {
        this.init();
    }

    public LLDP(boolean writeAccess) {
        super(writeAccess);
        this.init();
    }

    private void init() {
        this.mandatoryTLVs = new LinkedHashMap<Byte, LLDPTLV>(3);
        this.optionalTLVs = new LinkedHashMap<Byte, LLDPTLV>();
        this.customTLVs = new LinkedHashMap<CustomTLVKey, LLDPTLV>();
    }

    private byte getType(String typeDesc) {
        if (typeDesc.equals(CHASSISID)) {
            return LLDPTLV.TLVType.ChassisID.getValue();
        }
        if (typeDesc.equals(PORTID)) {
            return LLDPTLV.TLVType.PortID.getValue();
        }
        if (typeDesc.equals(TTL)) {
            return LLDPTLV.TLVType.TTL.getValue();
        }
        if (typeDesc.equals(SYSTEMNAMEID)) {
            return LLDPTLV.TLVType.SystemName.getValue();
        }
        return LLDPTLV.TLVType.Unknown.getValue();
    }

    private LLDPTLV getFromTLVs(Byte type) {
        LLDPTLV tlv = null;
        tlv = this.mandatoryTLVs.get(type);
        if (tlv == null) {
            tlv = this.optionalTLVs.get(type);
        }
        return tlv;
    }

    private void putToTLVs(Byte type, LLDPTLV tlv) {
        if (type.byteValue() == LLDPTLV.TLVType.ChassisID.getValue() || type.byteValue() == LLDPTLV.TLVType.PortID.getValue() || type.byteValue() == LLDPTLV.TLVType.TTL.getValue()) {
            this.mandatoryTLVs.put(type, tlv);
        } else if (type.byteValue() != LLDPTLV.TLVType.Custom.getValue()) {
            this.optionalTLVs.put(type, tlv);
        }
    }

    public LLDPTLV getTLV(String type) {
        return this.getFromTLVs(this.getType(type));
    }

    public LLDPTLV getCustomTLV(CustomTLVKey key) {
        return this.customTLVs.get(key);
    }

    public void setTLV(String type, LLDPTLV tlv) {
        this.putToTLVs(this.getType(type), tlv);
    }

    public LLDPTLV getChassisId() {
        return this.getTLV(CHASSISID);
    }

    public LLDP setChassisId(LLDPTLV chassisId) {
        this.setTLV(CHASSISID, chassisId);
        return this;
    }

    public LLDPTLV getSystemNameId() {
        return this.getTLV(SYSTEMNAMEID);
    }

    public LLDP setSystemNameId(LLDPTLV systemNameId) {
        this.setTLV(SYSTEMNAMEID, systemNameId);
        return this;
    }

    public LLDPTLV getPortId() {
        return this.getTLV(PORTID);
    }

    public LLDP setPortId(LLDPTLV portId) {
        this.setTLV(PORTID, portId);
        return this;
    }

    public LLDPTLV getTtl() {
        return this.getTLV(TTL);
    }

    public LLDP setTtl(LLDPTLV ttl) {
        this.setTLV(TTL, ttl);
        return this;
    }

    public Iterable<LLDPTLV> getOptionalTLVList() {
        return this.optionalTLVs.values();
    }

    public Iterable<LLDPTLV> getCustomTlvList() {
        return this.customTLVs.values();
    }

    public LLDP setOptionalTLVList(List<LLDPTLV> optionalTLVList) {
        for (LLDPTLV tlv : optionalTLVList) {
            this.optionalTLVs.put(tlv.getType(), tlv);
        }
        return this;
    }

    public LLDP addCustomTLV(LLDPTLV customTLV) {
        CustomTLVKey key = new CustomTLVKey(LLDPTLV.extractCustomOUI(customTLV), LLDPTLV.extractCustomSubtype(customTLV));
        this.customTLVs.put(key, customTLV);
        return this;
    }

    @Override
    public Packet deserialize(byte[] data, int bitOffset, int size) throws PacketException {
        int lldpOffset = bitOffset;
        int lldpSize = size;
        if (LOG.isTraceEnabled()) {
            LOG.trace("LLDP: {} (offset {} bitsize {})", new Object[]{HexEncode.bytesToHexString(data), lldpOffset, lldpSize});
        }
        while (lldpSize > 0) {
            LLDPTLV tlv = new LLDPTLV();
            tlv.deserialize(data, lldpOffset, lldpSize);
            if (tlv.getType() == 0 && tlv.getLength() == 0) break;
            int tlvSize = tlv.getTLVSize();
            lldpOffset += tlvSize;
            lldpSize -= tlvSize;
            if (tlv.getType() == LLDPTLV.TLVType.Custom.getValue()) {
                this.addCustomTLV(tlv);
                continue;
            }
            this.putToTLVs(tlv.getType(), tlv);
        }
        return this;
    }

    @Override
    public byte[] serialize() throws PacketException {
        int startOffset = 0;
        byte[] serializedBytes = new byte[this.getLLDPPacketLength()];
        Iterable allTlvs = Iterables.concat(this.mandatoryTLVs.values(), this.optionalTLVs.values(), this.customTLVs.values());
        for (LLDPTLV tlv : allTlvs) {
            int numBits = tlv.getTLVSize();
            try {
                BitBufferHelper.setBytes(serializedBytes, tlv.serialize(), startOffset, numBits);
            }
            catch (BufferException e) {
                throw new PacketException(e.getMessage());
            }
            startOffset += numBits;
        }
        try {
            BitBufferHelper.setBytes(serializedBytes, emptyTLV.serialize(), startOffset, emptyTLV.getTLVSize());
        }
        catch (BufferException e) {
            throw new PacketException(e.getMessage());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("LLDP: serialized: {}", (Object)HexEncode.bytesToHexString(serializedBytes));
        }
        return serializedBytes;
    }

    private int getLLDPPacketLength() {
        int len = 0;
        for (LLDPTLV lldptlv : Iterables.concat(this.mandatoryTLVs.values(), this.optionalTLVs.values(), this.customTLVs.values())) {
            len += lldptlv.getTLVSize();
        }
        return (len += emptyTLV.getTLVSize()) / 8;
    }
}

