/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.liblldp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);
    public static final int NumBitsInAByte = 8;
    public static final int MACAddrLengthInBytes = 6;
    public static final int MACAddrLengthInWords = 3;
    private static final byte[] BroadcastMACAddr = new byte[]{-1, -1, -1, -1, -1, -1};

    public static int byteArray4ToInt(byte[] ba) {
        if (ba == null || ba.length != 4) {
            return 0;
        }
        return (0xFF & ba[0]) << 24 | (0xFF & ba[1]) << 16 | (0xFF & ba[2]) << 8 | 0xFF & ba[3];
    }

    public static long byteArray6ToLong(byte[] ba) {
        if (ba == null || ba.length != 6) {
            return 0L;
        }
        long num = 0L;
        int i = 0;
        do {
            num <<= 8;
            num |= (long)(0xFF & ba[i]);
        } while (++i < 6);
        return num;
    }

    public static byte[] longToByteArray6(long addr) {
        byte[] mac = new byte[6];
        int i = 5;
        do {
            mac[i] = (byte)addr;
            addr >>>= 8;
        } while (--i >= 0);
        return mac;
    }

    public static byte[] intToByteArray4(int i) {
        return new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    public static InetAddress getInetAddress(int address) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByAddress(NetUtils.intToByteArray4(address));
        }
        catch (UnknownHostException e) {
            LOG.error("", (Throwable)e);
        }
        return ip;
    }

    public static InetAddress getInetNetworkMask(int prefixMaskLength, boolean isV6) {
        if (prefixMaskLength < 0 || !isV6 && prefixMaskLength > 32 || isV6 && prefixMaskLength > 128) {
            return null;
        }
        byte[] v4Address = new byte[]{0, 0, 0, 0};
        byte[] v6Address = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] address = isV6 ? v6Address : v4Address;
        int numBytes = prefixMaskLength / 8;
        int numBits = prefixMaskLength % 8;
        for (int i = 0; i < numBytes; ++i) {
            address[i] = -1;
        }
        if (numBits > 0) {
            int rem = 0;
            for (int j = 0; j < numBits; ++j) {
                rem |= 1 << 7 - j;
            }
            address[i] = (byte)rem;
        }
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static int getSubnetMaskLength(byte[] subnetMask) {
        int maskLength = 0;
        if (subnetMask != null && (subnetMask.length == 4 || subnetMask.length == 16)) {
            int index;
            for (index = 0; index < subnetMask.length && subnetMask[index] == -1; ++index) {
                maskLength += 8;
            }
            if (index != subnetMask.length) {
                int bits = 7;
                while (bits >= 0 && (subnetMask[index] & 1 << bits) != 0) {
                    --bits;
                    ++maskLength;
                }
            }
        }
        return maskLength;
    }

    public static int getSubnetMaskLength(InetAddress subnetMask) {
        return subnetMask == null ? 0 : NetUtils.getSubnetMaskLength(subnetMask.getAddress());
    }

    public static InetAddress getSubnetPrefix(InetAddress ip, int maskLen) {
        int bytes = maskLen / 8;
        int bits = maskLen % 8;
        byte[] sn = ip.getAddress();
        if (bits > 0) {
            byte modifiedByte = (byte)(sn[bytes] >> 8 - bits);
            sn[bytes] = (byte)(modifiedByte << 8 - bits);
            ++bytes;
        }
        while (bytes < sn.length) {
            sn[bytes] = 0;
            ++bytes;
        }
        try {
            return InetAddress.getByAddress(sn);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean inetAddressConflict(InetAddress testAddress, InetAddress filterAddress, InetAddress testMask, InetAddress filterMask) {
        InetAddress prefix2;
        int filterMaskLen;
        int testMaskLen;
        if (testAddress == null || filterAddress == null) {
            return false;
        }
        if (NetUtils.isAny(testAddress) || NetUtils.isAny(filterAddress)) {
            return false;
        }
        int n = testMask == null ? (testAddress instanceof Inet4Address ? 32 : 128) : (testMaskLen = NetUtils.getSubnetMaskLength(testMask));
        int n2 = filterMask == null ? (testAddress instanceof Inet4Address ? 32 : 128) : (filterMaskLen = NetUtils.getSubnetMaskLength(filterMask));
        if (testMaskLen < filterMaskLen) {
            return true;
        }
        InetAddress prefix1 = NetUtils.getSubnetPrefix(testAddress, filterMaskLen);
        return !prefix1.equals(prefix2 = NetUtils.getSubnetPrefix(filterAddress, filterMaskLen));
    }

    public static boolean isZeroMAC(byte[] mac) {
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            if (mac[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isBroadcastMACAddr(byte[] MACAddress) {
        if (MACAddress.length == 6) {
            for (int i = 0; i < 6; ++i) {
                if (MACAddress[i] == BroadcastMACAddr[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isUnicastMACAddr(byte[] MACAddress) {
        if (MACAddress.length == 6) {
            return (MACAddress[0] & 1) == 0;
        }
        return false;
    }

    public static boolean isMulticastMACAddr(byte[] MACAddress) {
        if (MACAddress.length == 6 && !NetUtils.isBroadcastMACAddr(MACAddress)) {
            return (MACAddress[0] & 1) != 0;
        }
        return false;
    }

    public static boolean isAny(InetAddress ip) {
        for (byte b : ip.getAddress()) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean fieldsConflict(int field1, int field2) {
        return field1 != 0 && field2 != 0 && field1 != field2;
    }

    public static InetAddress parseInetAddress(String addressString) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addressString);
        }
        catch (UnknownHostException e) {
            LOG.error("", (Throwable)e);
        }
        return address;
    }

    public static boolean isIPv4AddressValid(String cidr) {
        int prefix;
        if (cidr == null) {
            return false;
        }
        String[] values = cidr.split("/");
        Pattern ipv4Pattern = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        Matcher mm = ipv4Pattern.matcher(values[0]);
        if (!mm.matches()) {
            return false;
        }
        return values.length < 2 || (prefix = Integer.valueOf(values[1]).intValue()) >= 0 && prefix <= 32;
    }

    public static boolean isIPv6AddressValid(String cidr) {
        int prefix;
        if (cidr == null) {
            return false;
        }
        String[] values = cidr.split("/");
        try {
            InetAddress addr = InetAddress.getByName(values[0]);
            if (!(addr instanceof Inet6Address)) {
                return false;
            }
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return values.length < 2 || (prefix = Integer.valueOf(values[1]).intValue()) >= 0 && prefix <= 128;
    }

    public static boolean isIPAddressValid(String cidr) {
        return NetUtils.isIPv4AddressValid(cidr) || NetUtils.isIPv6AddressValid(cidr);
    }

    public static int getUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int getUnsignedShort(short s) {
        return s & 0xFFFF;
    }

    public static InetAddress gethighestIP(boolean v6) {
        try {
            return v6 ? InetAddress.getByName("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff") : InetAddress.getByName("255.255.255.255");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static byte[] getBroadcastMACAddr() {
        return Arrays.copyOf(BroadcastMACAddr, BroadcastMACAddr.length);
    }
}

