/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.logback.config.ConsoleAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.FileAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.LogbackModuleMXBean;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeRegistrator;
import org.opendaylight.controller.config.yang.logback.config.LoggerTO;
import org.opendaylight.controller.config.yang.logback.config.RollingFileAppenderTO;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-07-16", name="config-logging", namespace="urn:opendaylight:params:xml:ns:yang:controller:logback:config")
@Description(value="Actual state of logback configuration.")
public abstract class AbstractLogbackModule
extends AbstractModule<AbstractLogbackModule>
implements LogbackModuleMXBean,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogbackModule.class);
    public static final JmxAttribute consoleAppendersJmxAttribute = new JmxAttribute("ConsoleAppenderTO");
    private List<ConsoleAppenderTO> consoleAppenders = new ArrayList<ConsoleAppenderTO>();
    public static final JmxAttribute fileAppendersJmxAttribute = new JmxAttribute("FileAppenderTO");
    private List<FileAppenderTO> fileAppenders = new ArrayList<FileAppenderTO>();
    public static final JmxAttribute loggersJmxAttribute = new JmxAttribute("LoggerTO");
    private List<LoggerTO> loggers = new ArrayList<LoggerTO>();
    public static final JmxAttribute rollingAppendersJmxAttribute = new JmxAttribute("RollingFileAppenderTO");
    private List<RollingFileAppenderTO> rollingAppenders = new ArrayList<RollingFileAppenderTO>();
    private LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public AbstractLogbackModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractLogbackModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractLogbackModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public LogbackRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new LogbackRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final void resolveDependencies() {
        if (this.consoleAppenders != null) {
            for (ConsoleAppenderTO consoleAppenderTO : this.consoleAppenders) {
                consoleAppenderTO.injectDependencyResolver(this.dependencyResolver);
            }
        }
        if (this.fileAppenders != null) {
            for (FileAppenderTO fileAppenderTO : this.fileAppenders) {
                fileAppenderTO.injectDependencyResolver(this.dependencyResolver);
            }
        }
        if (this.loggers != null) {
            for (LoggerTO loggerTO : this.loggers) {
                loggerTO.injectDependencyResolver(this.dependencyResolver);
            }
        }
        if (this.rollingAppenders != null) {
            for (RollingFileAppenderTO rollingFileAppenderTO : this.rollingAppenders) {
                rollingFileAppenderTO.injectDependencyResolver(this.dependencyResolver);
            }
        }
    }

    public boolean canReuseInstance(AbstractLogbackModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractLogbackModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.consoleAppenders, other.consoleAppenders)) {
            return false;
        }
        if (!Objects.deepEquals(this.fileAppenders, other.fileAppenders)) {
            return false;
        }
        if (!Objects.deepEquals(this.loggers, other.loggers)) {
            return false;
        }
        return Objects.deepEquals(this.rollingAppenders, other.rollingAppenders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLogbackModule that = (AbstractLogbackModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public List<ConsoleAppenderTO> getConsoleAppenderTO() {
        return this.consoleAppenders;
    }

    @Override
    public void setConsoleAppenderTO(List<ConsoleAppenderTO> consoleAppenders) {
        this.consoleAppenders = consoleAppenders;
    }

    @Override
    public List<FileAppenderTO> getFileAppenderTO() {
        return this.fileAppenders;
    }

    @Override
    public void setFileAppenderTO(List<FileAppenderTO> fileAppenders) {
        this.fileAppenders = fileAppenders;
    }

    @Override
    public List<LoggerTO> getLoggerTO() {
        return this.loggers;
    }

    @Override
    public void setLoggerTO(List<LoggerTO> loggers) {
        this.loggers = loggers;
    }

    @Override
    public List<RollingFileAppenderTO> getRollingFileAppenderTO() {
        return this.rollingAppenders;
    }

    @Override
    public void setRollingFileAppenderTO(List<RollingFileAppenderTO> rollingAppenders) {
        this.rollingAppenders = rollingAppenders;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

