/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.Logback;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.ConsoleAppenders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.FileAppenders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.Loggers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.RollingAppenders;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LogbackBuilder
implements Builder<Logback> {
    private List<ConsoleAppenders> _consoleAppenders;
    private List<FileAppenders> _fileAppenders;
    private List<Loggers> _loggers;
    private List<RollingAppenders> _rollingAppenders;
    Map<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> augmentation = Collections.emptyMap();

    public LogbackBuilder() {
    }

    public LogbackBuilder(Logback base) {
        AugmentationHolder casted;
        this._consoleAppenders = base.getConsoleAppenders();
        this._fileAppenders = base.getFileAppenders();
        this._loggers = base.getLoggers();
        this._rollingAppenders = base.getRollingAppenders();
        if (base instanceof LogbackImpl) {
            LogbackImpl impl = (LogbackImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>(casted.augmentations());
        }
    }

    public List<ConsoleAppenders> getConsoleAppenders() {
        return this._consoleAppenders;
    }

    public List<FileAppenders> getFileAppenders() {
        return this._fileAppenders;
    }

    public List<Loggers> getLoggers() {
        return this._loggers;
    }

    public List<RollingAppenders> getRollingAppenders() {
        return this._rollingAppenders;
    }

    public <E extends Augmentation<Logback>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LogbackBuilder setConsoleAppenders(List<ConsoleAppenders> value) {
        this._consoleAppenders = value;
        return this;
    }

    public LogbackBuilder setFileAppenders(List<FileAppenders> value) {
        this._fileAppenders = value;
        return this;
    }

    public LogbackBuilder setLoggers(List<Loggers> value) {
        this._loggers = value;
        return this;
    }

    public LogbackBuilder setRollingAppenders(List<RollingAppenders> value) {
        this._rollingAppenders = value;
        return this;
    }

    public LogbackBuilder addAugmentation(Class<? extends Augmentation<Logback>> augmentationType, Augmentation<Logback> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LogbackBuilder removeAugmentation(Class<? extends Augmentation<Logback>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Logback build() {
        return new LogbackImpl(this);
    }

    private static final class LogbackImpl
    implements Logback {
        private final List<ConsoleAppenders> _consoleAppenders;
        private final List<FileAppenders> _fileAppenders;
        private final List<Loggers> _loggers;
        private final List<RollingAppenders> _rollingAppenders;
        private Map<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Logback> getImplementedInterface() {
            return Logback.class;
        }

        private LogbackImpl(LogbackBuilder base) {
            this._consoleAppenders = base.getConsoleAppenders();
            this._fileAppenders = base.getFileAppenders();
            this._loggers = base.getLoggers();
            this._rollingAppenders = base.getRollingAppenders();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>(base.augmentation);
                }
            }
        }

        @Override
        public List<ConsoleAppenders> getConsoleAppenders() {
            return this._consoleAppenders;
        }

        @Override
        public List<FileAppenders> getFileAppenders() {
            return this._fileAppenders;
        }

        @Override
        public List<Loggers> getLoggers() {
            return this._loggers;
        }

        @Override
        public List<RollingAppenders> getRollingAppenders() {
            return this._rollingAppenders;
        }

        public <E extends Augmentation<Logback>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._consoleAppenders);
            result = 31 * result + Objects.hashCode(this._fileAppenders);
            result = 31 * result + Objects.hashCode(this._loggers);
            result = 31 * result + Objects.hashCode(this._rollingAppenders);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Logback.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Logback other = (Logback)obj;
            if (!Objects.equals(this._consoleAppenders, other.getConsoleAppenders())) {
                return false;
            }
            if (!Objects.equals(this._fileAppenders, other.getFileAppenders())) {
                return false;
            }
            if (!Objects.equals(this._loggers, other.getLoggers())) {
                return false;
            }
            if (!Objects.equals(this._rollingAppenders, other.getRollingAppenders())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LogbackImpl otherImpl = (LogbackImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Logback [");
            boolean first = true;
            if (this._consoleAppenders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_consoleAppenders=");
                builder.append(this._consoleAppenders);
            }
            if (this._fileAppenders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fileAppenders=");
                builder.append(this._fileAppenders);
            }
            if (this._loggers != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loggers=");
                builder.append(this._loggers);
            }
            if (this._rollingAppenders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rollingAppenders=");
                builder.append(this._rollingAppenders);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

