/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.Loggers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.LoggersKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LoggersBuilder
implements Builder<Loggers> {
    private List<String> _appenders;
    private LoggersKey _key;
    private String _level;
    private String _loggerName;
    Map<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> augmentation = Collections.emptyMap();

    public LoggersBuilder() {
    }

    public LoggersBuilder(Loggers base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new LoggersKey(base.getLoggerName());
            this._loggerName = base.getLoggerName();
        } else {
            this._key = base.getKey();
            this._loggerName = this._key.getLoggerName();
        }
        this._appenders = base.getAppenders();
        this._level = base.getLevel();
        if (base instanceof LoggersImpl) {
            LoggersImpl impl = (LoggersImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>(casted.augmentations());
        }
    }

    public List<String> getAppenders() {
        return this._appenders;
    }

    public LoggersKey getKey() {
        return this._key;
    }

    public String getLevel() {
        return this._level;
    }

    public String getLoggerName() {
        return this._loggerName;
    }

    public <E extends Augmentation<Loggers>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LoggersBuilder setAppenders(List<String> value) {
        this._appenders = value;
        return this;
    }

    public LoggersBuilder setKey(LoggersKey value) {
        this._key = value;
        return this;
    }

    public LoggersBuilder setLevel(String value) {
        this._level = value;
        return this;
    }

    public LoggersBuilder setLoggerName(String value) {
        this._loggerName = value;
        return this;
    }

    public LoggersBuilder addAugmentation(Class<? extends Augmentation<Loggers>> augmentationType, Augmentation<Loggers> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LoggersBuilder removeAugmentation(Class<? extends Augmentation<Loggers>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Loggers build() {
        return new LoggersImpl(this);
    }

    private static final class LoggersImpl
    implements Loggers {
        private final List<String> _appenders;
        private final LoggersKey _key;
        private final String _level;
        private final String _loggerName;
        private Map<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Loggers> getImplementedInterface() {
            return Loggers.class;
        }

        private LoggersImpl(LoggersBuilder base) {
            if (base.getKey() == null) {
                this._key = new LoggersKey(base.getLoggerName());
                this._loggerName = base.getLoggerName();
            } else {
                this._key = base.getKey();
                this._loggerName = this._key.getLoggerName();
            }
            this._appenders = base.getAppenders();
            this._level = base.getLevel();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>(base.augmentation);
                }
            }
        }

        @Override
        public List<String> getAppenders() {
            return this._appenders;
        }

        @Override
        public LoggersKey getKey() {
            return this._key;
        }

        @Override
        public String getLevel() {
            return this._level;
        }

        @Override
        public String getLoggerName() {
            return this._loggerName;
        }

        public <E extends Augmentation<Loggers>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._appenders);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._level);
            result = 31 * result + Objects.hashCode(this._loggerName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Loggers.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Loggers other = (Loggers)obj;
            if (!Objects.equals(this._appenders, other.getAppenders())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._level, other.getLevel())) {
                return false;
            }
            if (!Objects.equals(this._loggerName, other.getLoggerName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LoggersImpl otherImpl = (LoggersImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Loggers [");
            boolean first = true;
            if (this._appenders != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_appenders=");
                builder.append(this._appenders);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._level != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_level=");
                builder.append(this._level);
            }
            if (this._loggerName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loggerName=");
                builder.append(this._loggerName);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

