/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.state.logback;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.state.logback.Status;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatusBuilder
implements Builder<Status> {
    private Long _date;
    private String _level;
    private String _message;
    Map<Class<? extends Augmentation<Status>>, Augmentation<Status>> augmentation = Collections.emptyMap();

    public StatusBuilder() {
    }

    public StatusBuilder(Status base) {
        AugmentationHolder casted;
        this._date = base.getDate();
        this._level = base.getLevel();
        this._message = base.getMessage();
        if (base instanceof StatusImpl) {
            StatusImpl impl = (StatusImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>(casted.augmentations());
        }
    }

    public Long getDate() {
        return this._date;
    }

    public String getLevel() {
        return this._level;
    }

    public String getMessage() {
        return this._message;
    }

    public <E extends Augmentation<Status>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public StatusBuilder setDate(Long value) {
        if (value != null) {
            StatusBuilder.checkDateRange(value);
        }
        this._date = value;
        return this;
    }

    public StatusBuilder setLevel(String value) {
        this._level = value;
        return this;
    }

    public StatusBuilder setMessage(String value) {
        this._message = value;
        return this;
    }

    public StatusBuilder addAugmentation(Class<? extends Augmentation<Status>> augmentationType, Augmentation<Status> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StatusBuilder removeAugmentation(Class<? extends Augmentation<Status>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Status build() {
        return new StatusImpl(this);
    }

    private static final class StatusImpl
    implements Status {
        private final Long _date;
        private final String _level;
        private final String _message;
        private Map<Class<? extends Augmentation<Status>>, Augmentation<Status>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Status> getImplementedInterface() {
            return Status.class;
        }

        private StatusImpl(StatusBuilder base) {
            this._date = base.getDate();
            this._level = base.getLevel();
            this._message = base.getMessage();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Status>>, Augmentation<Status>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDate() {
            return this._date;
        }

        @Override
        public String getLevel() {
            return this._level;
        }

        @Override
        public String getMessage() {
            return this._message;
        }

        public <E extends Augmentation<Status>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._date);
            result = 31 * result + Objects.hashCode(this._level);
            result = 31 * result + Objects.hashCode(this._message);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Status.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Status other = (Status)obj;
            if (!Objects.equals(this._date, other.getDate())) {
                return false;
            }
            if (!Objects.equals(this._level, other.getLevel())) {
                return false;
            }
            if (!Objects.equals(this._message, other.getMessage())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatusImpl otherImpl = (StatusImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Status>>, Augmentation<Status>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Status [");
            boolean first = true;
            if (this._date != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_date=");
                builder.append(this._date);
            }
            if (this._level != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_level=");
                builder.append(this._level);
            }
            if (this._message != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_message=");
                builder.append(this._message);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

