/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netconf.mdsal.mapper;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.config.yang.netconf.mdsal.mapper.NetconfMdsalMapperModuleMXBean;
import org.opendaylight.controller.config.yang.netconf.north.mapper.NetconfOperationServiceFactoryListenerServiceInterface;
import org.opendaylight.controller.config.yang.netconf.north.mapper.NetconfOperationServiceFactoryServiceInterface;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactoryListener;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2015-01-14", name="netconf-mdsal-mapper", namespace="urn:opendaylight:params:xml:ns:yang:controller:netconf:mdsal:mapper")
public abstract class AbstractNetconfMdsalMapperModule
extends AbstractModule<AbstractNetconfMdsalMapperModule>
implements NetconfMdsalMapperModuleMXBean,
NetconfOperationServiceFactoryServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetconfMdsalMapperModule.class);
    public static final JmxAttribute rootSchemaServiceJmxAttribute = new JmxAttribute("RootSchemaService");
    private ObjectName rootSchemaService;
    public static final JmxAttribute domBrokerJmxAttribute = new JmxAttribute("DomBroker");
    private ObjectName domBroker;
    public static final JmxAttribute mapperAggregatorJmxAttribute = new JmxAttribute("MapperAggregator");
    private ObjectName mapperAggregator;
    private SchemaService rootSchemaServiceDependency;
    private Broker domBrokerDependency;
    private NetconfOperationServiceFactoryListener mapperAggregatorDependency;

    public AbstractNetconfMdsalMapperModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractNetconfMdsalMapperModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractNetconfMdsalMapperModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.rootSchemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.rootSchemaService, rootSchemaServiceJmxAttribute);
        }
        this.dependencyResolver.validateDependency(BrokerServiceInterface.class, this.domBroker, domBrokerJmxAttribute);
        this.dependencyResolver.validateDependency(NetconfOperationServiceFactoryListenerServiceInterface.class, this.mapperAggregator, mapperAggregatorJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final SchemaService getRootSchemaServiceDependency() {
        return this.rootSchemaServiceDependency;
    }

    protected final Broker getDomBrokerDependency() {
        return this.domBrokerDependency;
    }

    protected final NetconfOperationServiceFactoryListener getMapperAggregatorDependency() {
        return this.mapperAggregatorDependency;
    }

    protected final void resolveDependencies() {
        if (this.rootSchemaService != null) {
            this.rootSchemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.rootSchemaService, rootSchemaServiceJmxAttribute);
        }
        this.mapperAggregatorDependency = (NetconfOperationServiceFactoryListener)this.dependencyResolver.resolveInstance(NetconfOperationServiceFactoryListener.class, this.mapperAggregator, mapperAggregatorJmxAttribute);
        this.domBrokerDependency = (Broker)this.dependencyResolver.resolveInstance(Broker.class, this.domBroker, domBrokerJmxAttribute);
    }

    public boolean canReuseInstance(AbstractNetconfMdsalMapperModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractNetconfMdsalMapperModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.rootSchemaService, other.rootSchemaService)) {
            return false;
        }
        if (this.rootSchemaService != null && !this.dependencyResolver.canReuseDependency(this.rootSchemaService, rootSchemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.domBroker, other.domBroker)) {
            return false;
        }
        if (this.domBroker != null && !this.dependencyResolver.canReuseDependency(this.domBroker, domBrokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.mapperAggregator, other.mapperAggregator)) {
            return false;
        }
        return this.mapperAggregator == null || this.dependencyResolver.canReuseDependency(this.mapperAggregator, mapperAggregatorJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNetconfMdsalMapperModule that = (AbstractNetconfMdsalMapperModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getRootSchemaService() {
        return this.rootSchemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setRootSchemaService(ObjectName rootSchemaService) {
        this.rootSchemaService = rootSchemaService;
    }

    @Override
    public ObjectName getDomBroker() {
        return this.domBroker;
    }

    @Override
    @RequireInterface(value=BrokerServiceInterface.class)
    public void setDomBroker(ObjectName domBroker) {
        this.domBroker = domBroker;
    }

    @Override
    public ObjectName getMapperAggregator() {
        return this.mapperAggregator;
    }

    @Override
    @RequireInterface(value=NetconfOperationServiceFactoryListenerServiceInterface.class)
    public void setMapperAggregator(ObjectName mapperAggregator) {
        this.mapperAggregator = mapperAggregator;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

