/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.netconf.api.Capability;
import org.opendaylight.controller.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.controller.netconf.mdsal.connector.MdsalNetconfOperationServiceFactory;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

public class CurrentSchemaContext
implements SchemaContextListener,
AutoCloseable {
    final AtomicReference<SchemaContext> currentContext = new AtomicReference();
    private final ListenerRegistration<SchemaContextListener> schemaContextListenerListenerRegistration;
    private final Set<CapabilityListener> listeners = Collections.synchronizedSet(Sets.newHashSet());

    public SchemaContext getCurrentContext() {
        Preconditions.checkState((this.currentContext.get() != null ? 1 : 0) != 0, (Object)"Current context not received");
        return this.currentContext.get();
    }

    public CurrentSchemaContext(SchemaService schemaService) {
        this.schemaContextListenerListenerRegistration = schemaService.registerSchemaContextListener((SchemaContextListener)this);
    }

    public void onGlobalContextUpdated(SchemaContext schemaContext) {
        this.currentContext.set(schemaContext);
        Set<Capability> addedCaps = MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentContext.get());
        for (CapabilityListener listener : this.listeners) {
            listener.onCapabilitiesAdded(addedCaps);
        }
    }

    @Override
    public void close() throws Exception {
        this.listeners.clear();
        this.schemaContextListenerListenerRegistration.close();
        this.currentContext.set(null);
    }

    public AutoCloseable registerCapabilityListener(final CapabilityListener listener) {
        listener.onCapabilitiesAdded(MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentContext.get()));
        this.listeners.add(listener);
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                CurrentSchemaContext.this.listeners.remove(listener);
            }
        };
    }
}

