/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.netconf.api.Capability;
import org.opendaylight.controller.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.mdsal.connector.MdsalNetconfOperationService;
import org.opendaylight.controller.netconf.util.capability.BasicCapability;
import org.opendaylight.controller.netconf.util.capability.YangModuleCapability;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
Consumer,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalNetconfOperationServiceFactory.class);
    private Broker.ConsumerSession session = null;
    private DOMDataBroker dataBroker = null;
    private DOMRpcService rpcService = null;
    private final CurrentSchemaContext currentSchemaContext;

    public MdsalNetconfOperationServiceFactory(SchemaService schemaService) {
        this.currentSchemaContext = new CurrentSchemaContext((SchemaService)Preconditions.checkNotNull((Object)schemaService));
    }

    public MdsalNetconfOperationService createService(String netconfSessionIdForReporting) {
        Preconditions.checkState((this.dataBroker != null ? 1 : 0) != 0, (Object)"MD-SAL provider not yet initialized");
        return new MdsalNetconfOperationService(this.currentSchemaContext, netconfSessionIdForReporting, this.dataBroker, this.rpcService);
    }

    @Override
    public void close() throws Exception {
        this.currentSchemaContext.close();
    }

    public Set<Capability> getCapabilities() {
        return MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentSchemaContext.getCurrentContext());
    }

    static Set<Capability> transformCapabilities(SchemaContext currentContext) {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        capabilities.add((Capability)new BasicCapability("urn:ietf:params:netconf:capability:candidate:1.0"));
        Set modules = currentContext.getModules();
        for (Module module : modules) {
            Optional<YangModuleCapability> cap = MdsalNetconfOperationServiceFactory.moduleToCapability(module);
            if (cap.isPresent()) {
                capabilities.add((Capability)cap.get());
            }
            for (Module submodule : module.getSubmodules()) {
                cap = MdsalNetconfOperationServiceFactory.moduleToCapability(submodule);
                if (!cap.isPresent()) continue;
                capabilities.add((Capability)cap.get());
            }
        }
        return capabilities;
    }

    private static Optional<YangModuleCapability> moduleToCapability(Module module) {
        String source = module.getSource();
        if (source != null) {
            return Optional.of((Object)new YangModuleCapability(module, source));
        }
        LOG.warn("Missing source for module {}. This module will not be available from netconf server", (Object)module);
        return Optional.absent();
    }

    public AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        return this.currentSchemaContext.registerCapabilityListener(listener);
    }

    public void onSessionInitiated(Broker.ConsumerSession session) {
        this.session = (Broker.ConsumerSession)Preconditions.checkNotNull((Object)session);
        this.dataBroker = (DOMDataBroker)this.session.getService(DOMDataBroker.class);
        this.rpcService = (DOMRpcService)this.session.getService(DOMRpcService.class);
    }

    public Collection<Consumer.ConsumerFunctionality> getConsumerFunctionality() {
        return Collections.emptySet();
    }
}

