/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector;

import com.google.common.collect.Sets;
import java.util.Set;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Commit;
import org.opendaylight.controller.netconf.mdsal.connector.ops.DiscardChanges;
import org.opendaylight.controller.netconf.mdsal.connector.ops.EditConfig;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Lock;
import org.opendaylight.controller.netconf.mdsal.connector.ops.RuntimeRpc;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Unlock;
import org.opendaylight.controller.netconf.mdsal.connector.ops.get.Get;
import org.opendaylight.controller.netconf.mdsal.connector.ops.get.GetConfig;

final class OperationProvider {
    private final String netconfSessionIdForReporting;
    private final CurrentSchemaContext schemaContext;
    private final DOMDataBroker dataBroker;
    private final DOMRpcService rpcService;
    private final TransactionProvider transactionProvider;

    public OperationProvider(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, DOMDataBroker dataBroker, DOMRpcService rpcService) {
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
        this.schemaContext = schemaContext;
        this.dataBroker = dataBroker;
        this.rpcService = rpcService;
        this.transactionProvider = new TransactionProvider(this.dataBroker, netconfSessionIdForReporting);
    }

    Set<NetconfOperation> getOperations() {
        return Sets.newHashSet((Object[])new NetconfOperation[]{new Commit(this.netconfSessionIdForReporting, this.transactionProvider), new DiscardChanges(this.netconfSessionIdForReporting, this.transactionProvider), new EditConfig(this.netconfSessionIdForReporting, this.schemaContext, this.transactionProvider), new Get(this.netconfSessionIdForReporting, this.schemaContext, this.transactionProvider), new GetConfig(this.netconfSessionIdForReporting, this.schemaContext, this.transactionProvider), new Lock(this.netconfSessionIdForReporting), new Unlock(this.netconfSessionIdForReporting), new RuntimeRpc(this.netconfSessionIdForReporting, this.schemaContext, this.rpcService)});
    }
}

