/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionProvider.class);
    private final DOMDataBroker dataBroker;
    private DOMDataReadWriteTransaction candidateTransaction = null;
    private DOMDataReadWriteTransaction runningTransaction = null;
    private final List<DOMDataReadWriteTransaction> allOpenReadWriteTransactions = new ArrayList<DOMDataReadWriteTransaction>();
    private final String netconfSessionIdForReporting;
    private static final String NO_TRANSACTION_FOUND_FOR_SESSION = "No candidateTransaction found for session ";

    public TransactionProvider(DOMDataBroker dataBroker, String netconfSessionIdForReporting) {
        this.dataBroker = dataBroker;
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
    }

    @Override
    public synchronized void close() throws Exception {
        for (DOMDataReadWriteTransaction rwt : this.allOpenReadWriteTransactions) {
            rwt.cancel();
        }
        this.allOpenReadWriteTransactions.clear();
    }

    public synchronized Optional<DOMDataReadWriteTransaction> getCandidateTransaction() {
        if (this.candidateTransaction == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.candidateTransaction);
    }

    public synchronized DOMDataReadWriteTransaction getOrCreateTransaction() {
        if (this.getCandidateTransaction().isPresent()) {
            return (DOMDataReadWriteTransaction)this.getCandidateTransaction().get();
        }
        this.candidateTransaction = this.dataBroker.newReadWriteTransaction();
        this.allOpenReadWriteTransactions.add(this.candidateTransaction);
        return this.candidateTransaction;
    }

    public synchronized boolean commitTransaction() throws NetconfDocumentedException {
        if (!this.getCandidateTransaction().isPresent()) {
            LOG.debug("Making commit without open candidate transaction for session {}", (Object)this.netconfSessionIdForReporting);
            return true;
        }
        CheckedFuture future = this.candidateTransaction.submit();
        try {
            future.checkedGet();
        }
        catch (TransactionCommitFailedException e) {
            LOG.debug("Transaction {} failed on", (Object)this.candidateTransaction, (Object)e);
            throw new NetconfDocumentedException("Transaction commit failed on " + e.getMessage() + " " + this.netconfSessionIdForReporting, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
        this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
        this.candidateTransaction = null;
        return true;
    }

    public synchronized void abortTransaction() {
        LOG.debug("Aborting current candidateTransaction");
        Optional<DOMDataReadWriteTransaction> otx = this.getCandidateTransaction();
        if (!otx.isPresent()) {
            LOG.warn("discard-changes triggerd on an empty transaction for session: {}", (Object)this.netconfSessionIdForReporting);
            return;
        }
        this.candidateTransaction.cancel();
        this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
        this.candidateTransaction = null;
    }

    public synchronized DOMDataReadWriteTransaction createRunningTransaction() {
        this.runningTransaction = this.dataBroker.newReadWriteTransaction();
        this.allOpenReadWriteTransactions.add(this.runningTransaction);
        return this.runningTransaction;
    }

    public synchronized boolean commitRunningTransaction(DOMDataReadWriteTransaction tx) throws NetconfDocumentedException {
        this.allOpenReadWriteTransactions.remove(tx);
        CheckedFuture future = tx.submit();
        try {
            future.checkedGet();
        }
        catch (TransactionCommitFailedException e) {
            LOG.debug("Transaction {} failed on", (Object)tx, (Object)e);
            throw new NetconfDocumentedException("Transaction commit failed on " + e.getMessage() + " " + this.netconfSessionIdForReporting, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
        return true;
    }

    public synchronized void abortRunningTransaction(DOMDataReadWriteTransaction tx) {
        LOG.debug("Aborting current running Transaction");
        Preconditions.checkState((this.runningTransaction != null ? 1 : 0) != 0, (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.netconfSessionIdForReporting));
        tx.cancel();
        this.allOpenReadWriteTransactions.remove(tx);
    }
}

