/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Commit
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private static final String OPERATION_NAME = "commit";
    private final TransactionProvider transactionProvider;

    public Commit(String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        boolean commitStatus = this.transactionProvider.commitTransaction();
        LOG.trace("Commit completed successfully {}", (Object)commitStatus);
        return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.absent());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

