/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import java.util.HashMap;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscardChanges
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DiscardChanges.class);
    private static final String OPERATION_NAME = "discard-changes";
    private final TransactionProvider transactionProvider;

    public DiscardChanges(String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        try {
            this.transactionProvider.abortTransaction();
        }
        catch (IllegalStateException e) {
            LOG.warn("Abort failed ", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), "Operation failed. Use 'get-config' or 'edit-config' before triggering 'discard-changes' operation");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.absent());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

