/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.controller.netconf.mdsal.connector.ops.DataTreeChangeTracker;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.controller.netconf.mdsal.connector.ops.EditOperationStrategyProvider;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlCodecProvider;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.DomUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.parser.DomToNormalizedNodeParserFactory;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EditConfig
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(EditConfig.class);
    private static final String OPERATION_NAME = "edit-config";
    private static final String CONFIG_KEY = "config";
    private static final String TARGET_KEY = "target";
    private static final String DEFAULT_OPERATION_KEY = "default-operation";
    private final CurrentSchemaContext schemaContext;
    private final TransactionProvider transactionProvider;

    public EditConfig(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        Datastore targetDatastore = this.extractTargetParameter(operationElement);
        if (targetDatastore == Datastore.running) {
            throw new NetconfDocumentedException("edit-config on running datastore is not supported", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error);
        }
        ModifyAction defaultAction = this.getDefaultOperation(operationElement);
        XmlElement configElement = this.getElement(operationElement, CONFIG_KEY);
        for (XmlElement element : configElement.getChildElements()) {
            String ns = element.getNamespace();
            DataSchemaNode schemaNode = (DataSchemaNode)this.getSchemaNodeFromNamespace(ns, element).get();
            DataTreeChangeTracker changeTracker = new DataTreeChangeTracker(defaultAction);
            EditOperationStrategyProvider editOperationStrategyProvider = new EditOperationStrategyProvider(changeTracker);
            this.parseIntoNormalizedNode(schemaNode, element, editOperationStrategyProvider);
            this.executeOperations(changeTracker);
        }
        return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.absent());
    }

    private void executeOperations(DataTreeChangeTracker changeTracker) throws NetconfDocumentedException {
        DOMDataReadWriteTransaction rwTx = this.transactionProvider.getOrCreateTransaction();
        ArrayList<DataTreeChangeTracker.DataTreeChange> aa = changeTracker.getDataTreeChanges();
        ListIterator iterator = aa.listIterator(aa.size());
        while (iterator.hasPrevious()) {
            DataTreeChangeTracker.DataTreeChange dtc = (DataTreeChangeTracker.DataTreeChange)iterator.previous();
            this.executeChange(rwTx, dtc);
        }
    }

    private void executeChange(DOMDataReadWriteTransaction rwtx, DataTreeChangeTracker.DataTreeChange change) throws NetconfDocumentedException {
        switch (change.getAction()) {
            case NONE: {
                return;
            }
            case MERGE: {
                rwtx.merge(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create(change.getPath()), change.getChangeRoot());
                break;
            }
            case CREATE: {
                try {
                    Optional readResult = (Optional)rwtx.read(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create(change.getPath())).checkedGet();
                    if (readResult.isPresent()) {
                        throw new NetconfDocumentedException("Data already exists, cannot execute CREATE operation", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.data_exists, NetconfDocumentedException.ErrorSeverity.error);
                    }
                    rwtx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create(change.getPath()), change.getChangeRoot());
                }
                catch (ReadFailedException e) {
                    LOG.warn("Read from datastore failed when trying to read data for create operation", (Object)change, (Object)e);
                }
                break;
            }
            case REPLACE: {
                rwtx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create(change.getPath()), change.getChangeRoot());
                break;
            }
            case DELETE: {
                try {
                    Optional readResult = (Optional)rwtx.read(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create(change.getPath())).checkedGet();
                    if (!readResult.isPresent()) {
                        throw new NetconfDocumentedException("Data is missing, cannot execute DELETE operation", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.data_missing, NetconfDocumentedException.ErrorSeverity.error);
                    }
                    rwtx.delete(LogicalDatastoreType.CONFIGURATION, (Path)YangInstanceIdentifier.create(change.getPath()));
                }
                catch (ReadFailedException e) {
                    LOG.warn("Read from datastore failed when trying to read data for delete operation", (Object)change, (Object)e);
                }
                break;
            }
            case REMOVE: {
                rwtx.delete(LogicalDatastoreType.CONFIGURATION, (Path)YangInstanceIdentifier.create(change.getPath()));
                break;
            }
            default: {
                LOG.warn("Unknown/not implemented operation, not executing");
            }
        }
    }

    private NormalizedNode parseIntoNormalizedNode(DataSchemaNode schemaNode, XmlElement element, DomToNormalizedNodeParserFactory.BuildingStrategyProvider editOperationStrategyProvider) {
        if (schemaNode instanceof ContainerSchemaNode) {
            return DomToNormalizedNodeParserFactory.getInstance((XmlCodecProvider)DomUtils.defaultValueCodecProvider(), (SchemaContext)this.schemaContext.getCurrentContext(), (DomToNormalizedNodeParserFactory.BuildingStrategyProvider)editOperationStrategyProvider).getContainerNodeParser().parse(Collections.singletonList(element.getDomElement()), (Object)((ContainerSchemaNode)schemaNode));
        }
        if (schemaNode instanceof ListSchemaNode) {
            return DomToNormalizedNodeParserFactory.getInstance((XmlCodecProvider)DomUtils.defaultValueCodecProvider(), (SchemaContext)this.schemaContext.getCurrentContext(), (DomToNormalizedNodeParserFactory.BuildingStrategyProvider)editOperationStrategyProvider).getMapNodeParser().parse(Collections.singletonList(element.getDomElement()), (Object)((ListSchemaNode)schemaNode));
        }
        LOG.debug("DataNode from module is not ContainerSchemaNode nor ListSchemaNode, aborting..");
        throw new UnsupportedOperationException("implement exception if parse fails");
    }

    private Optional<DataSchemaNode> getSchemaNodeFromNamespace(String namespace, XmlElement element) throws NetconfDocumentedException {
        Optional dataSchemaNode = Optional.absent();
        try {
            Module module = this.schemaContext.getCurrentContext().findModuleByNamespaceAndRevision(new URI(namespace), null);
            if (module == null) {
                throw new NetconfDocumentedException("Unable to find module by namespace: " + namespace, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.unknown_namespace, NetconfDocumentedException.ErrorSeverity.error);
            }
            DataSchemaNode schemaNode = module.getDataChildByName(element.getName());
            if (schemaNode == null) {
                throw new NetconfDocumentedException("Unable to find node with namespace: " + namespace + "in module: " + module.toString(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.unknown_namespace, NetconfDocumentedException.ErrorSeverity.error);
            }
            dataSchemaNode = Optional.of((Object)module.getDataChildByName(element.getName()));
        }
        catch (URISyntaxException e) {
            LOG.debug("Unable to create URI for namespace : {}", (Object)namespace);
        }
        return dataSchemaNode;
    }

    private Datastore extractTargetParameter(XmlElement operationElement) throws NetconfDocumentedException {
        NodeList elementsByTagName = operationElement.getDomElement().getElementsByTagName(TARGET_KEY);
        if (elementsByTagName.getLength() == 0) {
            throw new NetconfDocumentedException("Missing target element", NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.missing_attribute, NetconfDocumentedException.ErrorSeverity.error);
        }
        if (elementsByTagName.getLength() > 1) {
            throw new NetconfDocumentedException("Multiple target elements", NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.unknown_attribute, NetconfDocumentedException.ErrorSeverity.error);
        }
        XmlElement targetChildNode = XmlElement.fromDomElement((Element)((Element)elementsByTagName.item(0))).getOnlyChildElement();
        return Datastore.valueOf(targetChildNode.getName());
    }

    private ModifyAction getDefaultOperation(XmlElement operationElement) throws NetconfDocumentedException {
        NodeList elementsByTagName = operationElement.getDomElement().getElementsByTagName(DEFAULT_OPERATION_KEY);
        if (elementsByTagName.getLength() == 0) {
            return ModifyAction.MERGE;
        }
        if (elementsByTagName.getLength() > 1) {
            throw new NetconfDocumentedException("Multiple default-operation elements", NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.unknown_attribute, NetconfDocumentedException.ErrorSeverity.error);
        }
        return ModifyAction.fromXmlValue((String)elementsByTagName.item(0).getTextContent());
    }

    private XmlElement getElement(XmlElement operationElement, String elementName) throws NetconfDocumentedException {
        Optional childNode = operationElement.getOnlyChildElementOptionally(elementName);
        if (!childNode.isPresent()) {
            throw new NetconfDocumentedException(elementName + " element is missing", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.missing_element, NetconfDocumentedException.ErrorSeverity.error);
        }
        return (XmlElement)childNode.get();
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

