/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.opendaylight.controller.netconf.mdsal.connector.ops.DataTreeChangeTracker;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditConfigInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.AttributesBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.base.parser.ExtensibleParser;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.parser.DomToNormalizedNodeParserFactory;

class EditOperationStrategyProvider
extends DomToNormalizedNodeParserFactory.BuildingStrategyProvider {
    private static final QName OPERATION_ATTRIBUTE = QName.create((URI)EditConfigInput.QNAME.getNamespace(), null, (String)"operation");
    private final DataTreeChangeTracker changeTracker;

    public EditOperationStrategyProvider(DataTreeChangeTracker changeTracker) {
        this.changeTracker = changeTracker;
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, LeafNode<?>> forLeaf() {
        return new NetconfOperationLeafStrategy(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, ContainerNode> forContainer() {
        return new NetconfOperationContainerStrategy<YangInstanceIdentifier.NodeIdentifier, ContainerNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, MapNode> forMap() {
        return new NetconfOperationCollectionStrategy<MapNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<?>> forLeafSetEntry() {
        return new NetconfOperationLeafSetEntryStrategy(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> forMapEntry() {
        return new NetconfOperationContainerStrategy<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, OrderedMapNode> forOrderedList() {
        return new NetconfOperationCollectionStrategy<OrderedMapNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> forUnkeyedListEntry() {
        return new NetconfOperationContainerStrategy<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, UnkeyedListNode> forUnkeyedList() {
        return new NetconfOperationCollectionStrategy<UnkeyedListNode>(this.changeTracker);
    }

    protected ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> forChoice() {
        return new NetconfOperationContainerStrategy<YangInstanceIdentifier.NodeIdentifier, ChoiceNode>(this.changeTracker);
    }

    public ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.AugmentationIdentifier, AugmentationNode> forAugmentation() {
        return new NetconfOperationContainerStrategy<YangInstanceIdentifier.AugmentationIdentifier, AugmentationNode>(this.changeTracker);
    }

    public static final class NetconfOperationContainerStrategy<P extends YangInstanceIdentifier.PathArgument, N extends DataContainerNode<P>>
    implements ExtensibleParser.BuildingStrategy<P, N> {
        private final DataTreeChangeTracker dataTreeChangeTracker;

        public NetconfOperationContainerStrategy(DataTreeChangeTracker dataTreeChangeTracker) {
            this.dataTreeChangeTracker = dataTreeChangeTracker;
        }

        @Nullable
        public N build(NormalizedNodeBuilder<P, ?, N> builder) {
            if (builder instanceof AttributesBuilder) {
                ((AttributesBuilder)builder).withAttributes(Collections.emptyMap());
            }
            DataContainerNode node = (DataContainerNode)builder.build();
            ModifyAction currentAction = this.dataTreeChangeTracker.popAction();
            if (this.dataTreeChangeTracker.getDeleteOperationTracker() > 0 || this.dataTreeChangeTracker.getRemoveOperationTracker() > 0) {
                this.dataTreeChangeTracker.popPath();
                return (N)node;
            }
            if (!currentAction.equals((Object)this.dataTreeChangeTracker.peekAction())) {
                this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange((NormalizedNode<?, ?>)node, currentAction, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
                this.dataTreeChangeTracker.popPath();
                return null;
            }
            this.dataTreeChangeTracker.popPath();
            return (N)node;
        }

        public void prepareAttributes(Map<QName, String> attributes, NormalizedNodeBuilder<P, ?, N> containerBuilder) {
            this.dataTreeChangeTracker.pushPath(((DataContainerNode)containerBuilder.build()).getIdentifier());
            String operation = attributes.get(OPERATION_ATTRIBUTE);
            if (operation != null) {
                this.dataTreeChangeTracker.pushAction(ModifyAction.fromXmlValue((String)operation));
            } else {
                this.dataTreeChangeTracker.pushAction(this.dataTreeChangeTracker.peekAction() != null ? this.dataTreeChangeTracker.peekAction() : this.dataTreeChangeTracker.getDefaultAction());
            }
        }
    }

    public static final class NetconfOperationLeafSetEntryStrategy
    implements ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<?>> {
        private final DataTreeChangeTracker dataTreeChangeTracker;

        public NetconfOperationLeafSetEntryStrategy(DataTreeChangeTracker dataTreeChangeTracker) {
            this.dataTreeChangeTracker = dataTreeChangeTracker;
        }

        @Nullable
        public LeafSetEntryNode<?> build(NormalizedNodeBuilder<YangInstanceIdentifier.NodeWithValue, ?, LeafSetEntryNode<?>> builder) {
            LeafSetEntryNode node = (LeafSetEntryNode)builder.build();
            String operation = (String)node.getAttributeValue(OPERATION_ATTRIBUTE);
            if (operation == null) {
                return node;
            }
            if (builder instanceof AttributesBuilder) {
                ((AttributesBuilder)builder).withAttributes(Collections.emptyMap());
            }
            node = (LeafSetEntryNode)builder.build();
            ModifyAction action = ModifyAction.fromXmlValue((String)operation);
            if (this.dataTreeChangeTracker.getDeleteOperationTracker() > 0 || this.dataTreeChangeTracker.getRemoveOperationTracker() > 0) {
                return node;
            }
            if (!action.equals((Object)this.dataTreeChangeTracker.peekAction())) {
                this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)node.getIdentifier());
                this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange((NormalizedNode<?, ?>)node, action, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
                this.dataTreeChangeTracker.popPath();
                return null;
            }
            return node;
        }

        public void prepareAttributes(Map<QName, String> attributes, NormalizedNodeBuilder<YangInstanceIdentifier.NodeWithValue, ?, LeafSetEntryNode<?>> containerBuilder) {
        }
    }

    public static final class NetconfOperationLeafStrategy
    implements ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, LeafNode<?>> {
        private final DataTreeChangeTracker dataTreeChangeTracker;

        public NetconfOperationLeafStrategy(DataTreeChangeTracker dataTreeChangeTracker) {
            this.dataTreeChangeTracker = dataTreeChangeTracker;
        }

        @Nullable
        public LeafNode<?> build(NormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ?, LeafNode<?>> builder) {
            LeafNode node = (LeafNode)builder.build();
            String operation = (String)node.getAttributeValue(OPERATION_ATTRIBUTE);
            if (operation == null) {
                return node;
            }
            if (builder instanceof AttributesBuilder) {
                ((AttributesBuilder)builder).withAttributes(Collections.emptyMap());
            }
            node = (LeafNode)builder.build();
            ModifyAction action = ModifyAction.fromXmlValue((String)operation);
            if (this.dataTreeChangeTracker.getDeleteOperationTracker() > 0 || this.dataTreeChangeTracker.getRemoveOperationTracker() > 0) {
                return node;
            }
            if (!action.equals((Object)this.dataTreeChangeTracker.peekAction())) {
                this.dataTreeChangeTracker.pushPath(node.getIdentifier());
                this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange((NormalizedNode<?, ?>)node, action, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
                this.dataTreeChangeTracker.popPath();
                return null;
            }
            return node;
        }

        public void prepareAttributes(Map<QName, String> attributes, NormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ?, LeafNode<?>> containerBuilder) {
        }
    }

    private static class NetconfOperationCollectionStrategy<N extends NormalizedNode<YangInstanceIdentifier.NodeIdentifier, ?>>
    implements ExtensibleParser.BuildingStrategy<YangInstanceIdentifier.NodeIdentifier, N> {
        private final DataTreeChangeTracker changeTracker;

        public NetconfOperationCollectionStrategy(DataTreeChangeTracker changeTracker) {
            this.changeTracker = changeTracker;
        }

        @Nullable
        public N build(NormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ?, N> builder) {
            this.changeTracker.popPath();
            return (N)builder.build();
        }

        public void prepareAttributes(Map<QName, String> attributes, NormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ?, N> containerBuilder) {
            this.changeTracker.pushPath(containerBuilder.build().getIdentifier());
        }
    }
}

