/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.controller.netconf.util.exception.MissingNameSpaceException;
import org.opendaylight.controller.netconf.util.exception.UnexpectedNamespaceException;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Lock
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Lock.class);
    private static final String OPERATION_NAME = "lock";
    private static final String TARGET_KEY = "target";

    public Lock(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        Datastore targetDatastore = Lock.extractTargetParameter(operationElement);
        if (targetDatastore == Datastore.candidate) {
            LOG.debug("Locking candidate datastore on session: {}", (Object)this.getNetconfSessionIdForReporting());
            return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.absent());
        }
        throw new NetconfDocumentedException("Unable to lock " + (Object)((Object)targetDatastore) + " datastore", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error);
    }

    static Datastore extractTargetParameter(XmlElement operationElement) throws NetconfDocumentedException {
        XmlElement targetChildNode;
        try {
            XmlElement targetElement = operationElement.getOnlyChildElementWithSameNamespace(TARGET_KEY);
            targetChildNode = targetElement.getOnlyChildElementWithSameNamespace();
        }
        catch (MissingNameSpaceException | UnexpectedNamespaceException e) {
            LOG.trace("Can't get only child element with same namespace", e);
            throw NetconfDocumentedException.wrap((Exception)e);
        }
        return Datastore.valueOf(targetChildNode.getName());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

