/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.CheckedFuture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.util.OrderedNormalizedNodeWriter;
import org.opendaylight.controller.netconf.util.exception.MissingNameSpaceException;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlCodecProvider;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.DomUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.parser.DomToNormalizedNodeParserFactory;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuntimeRpc
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeRpc.class);
    private final CurrentSchemaContext schemaContext;
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private final DOMRpcService rpcService;

    public RuntimeRpc(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, DOMRpcService rpcService) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
        this.rpcService = rpcService;
    }

    protected HandlingPriority canHandle(String netconfOperationName, String namespace) {
        URI namespaceURI = this.createNsUri(namespace);
        Optional<Module> module = this.getModule(namespaceURI);
        if (!module.isPresent()) {
            LOG.debug("Cannot handle rpc: {}, {}", (Object)netconfOperationName, (Object)namespace);
            return HandlingPriority.CANNOT_HANDLE;
        }
        this.getRpcDefinitionFromModule((Module)module.get(), namespaceURI, netconfOperationName);
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected String getOperationName() {
        throw new UnsupportedOperationException("Runtime rpc does not have a stable name");
    }

    private URI createNsUri(String namespace) {
        URI namespaceURI;
        try {
            namespaceURI = new URI(namespace);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to parse URI " + namespace, e);
        }
        return namespaceURI;
    }

    private Optional<Module> getModule(URI namespaceURI) {
        return Optional.fromNullable((Object)this.schemaContext.getCurrentContext().findModuleByNamespaceAndRevision(namespaceURI, null));
    }

    private Optional<RpcDefinition> getRpcDefinitionFromModule(Module module, URI namespaceURI, String name) {
        for (RpcDefinition rpcDef : module.getRpcs()) {
            if (!rpcDef.getQName().getNamespace().equals(namespaceURI) || !rpcDef.getQName().getLocalName().equals(name)) continue;
            return Optional.of((Object)rpcDef);
        }
        return Optional.absent();
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        String netconfOperationNamespace;
        String netconfOperationName = operationElement.getName();
        try {
            netconfOperationNamespace = operationElement.getNamespace();
        }
        catch (MissingNameSpaceException e) {
            LOG.debug("Cannot retrieve netconf operation namespace from message due to ", (Throwable)e);
            throw new NetconfDocumentedException("Cannot retrieve netconf operation namespace from message", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.unknown_namespace, NetconfDocumentedException.ErrorSeverity.error);
        }
        URI namespaceURI = this.createNsUri(netconfOperationNamespace);
        Optional<Module> moduleOptional = this.getModule(namespaceURI);
        if (!moduleOptional.isPresent()) {
            throw new NetconfDocumentedException("Unable to find module in Schema Context with namespace and name : " + namespaceURI + " " + netconfOperationName + this.schemaContext.getCurrentContext(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.bad_element, NetconfDocumentedException.ErrorSeverity.error);
        }
        Optional<RpcDefinition> rpcDefinitionOptional = this.getRpcDefinitionFromModule((Module)moduleOptional.get(), namespaceURI, netconfOperationName);
        if (!rpcDefinitionOptional.isPresent()) {
            throw new NetconfDocumentedException("Unable to find RpcDefinition with namespace and name : " + namespaceURI + " " + netconfOperationName, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.bad_element, NetconfDocumentedException.ErrorSeverity.error);
        }
        RpcDefinition rpcDefinition = (RpcDefinition)rpcDefinitionOptional.get();
        SchemaPath schemaPath = SchemaPath.create(Collections.singletonList(rpcDefinition.getQName()), (boolean)true);
        NormalizedNode<?, ?> inputNode = this.rpcToNNode(operationElement, rpcDefinition.getInput());
        CheckedFuture rpcFuture = this.rpcService.invokeRpc(schemaPath, inputNode);
        try {
            DOMRpcResult result = (DOMRpcResult)rpcFuture.checkedGet();
            if (result.getResult() == null) {
                return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.of((Object)"urn:ietf:params:xml:ns:netconf:base:1.0"));
            }
            return (Element)this.transformNormalizedNode(document, result.getResult(), rpcDefinition.getOutput().getPath());
        }
        catch (DOMRpcException e) {
            throw NetconfDocumentedException.wrap((Exception)((Object)e));
        }
    }

    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws NetconfDocumentedException {
        XmlElement requestElement = RuntimeRpc.getRequestElementWithCheck((Document)requestMessage);
        Document document = XmlUtil.newDocument();
        XmlElement operationElement = requestElement.getOnlyChildElement();
        Map attributes = requestElement.getAttributes();
        Element response = this.handle(document, operationElement, subsequentOperation);
        Element rpcReply = XmlUtil.createElement((Document)document, (String)"rpc-reply", (Optional)Optional.of((Object)"urn:ietf:params:xml:ns:netconf:base:1.0"));
        if (XmlElement.fromDomElement((Element)response).hasNamespace()) {
            rpcReply.appendChild(response);
        } else {
            NodeList list = response.getChildNodes();
            if (list.getLength() == 0) {
                rpcReply.appendChild(response);
            } else {
                while (list.getLength() != 0) {
                    rpcReply.appendChild(list.item(0));
                }
            }
        }
        for (Attr attribute : attributes.values()) {
            rpcReply.setAttributeNode((Attr)document.importNode(attribute, true));
        }
        document.appendChild(rpcReply);
        return document;
    }

    private Node transformNormalizedNode(Document document, NormalizedNode<?, ?> data, SchemaPath rpcOutputPath) {
        DOMResult result = new DOMResult(document.createElement("rpc-reply"));
        XMLStreamWriter xmlWriter = this.getXmlStreamWriter(result);
        NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)this.schemaContext.getCurrentContext(), (SchemaPath)rpcOutputPath);
        OrderedNormalizedNodeWriter nnWriter = new OrderedNormalizedNodeWriter(nnStreamWriter, this.schemaContext.getCurrentContext(), rpcOutputPath);
        this.writeRootElement(xmlWriter, nnWriter, (ContainerNode)data);
        try {
            nnStreamWriter.close();
            xmlWriter.close();
        }
        catch (IOException | XMLStreamException e) {
            LOG.warn("Error while closing streams", (Throwable)e);
        }
        return result.getNode();
    }

    private XMLStreamWriter getXmlStreamWriter(DOMResult result) {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeRootElement(XMLStreamWriter xmlWriter, OrderedNormalizedNodeWriter nnWriter, ContainerNode data) {
        try {
            Collection value = data.getValue();
            nnWriter.write(value);
            nnWriter.flush();
            xmlWriter.flush();
        }
        catch (IOException | XMLStreamException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    private NormalizedNode<?, ?> rpcToNNode(XmlElement oElement, @Nullable ContainerSchemaNode input) {
        return input == null ? null : (ContainerNode)DomToNormalizedNodeParserFactory.getInstance((XmlCodecProvider)DomUtils.defaultValueCodecProvider(), (SchemaContext)this.schemaContext.getCurrentContext()).getContainerNodeParser().parse(Collections.singletonList(oElement.getDomElement()), (Object)input);
    }

    static {
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

