/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops;

import com.google.common.base.Optional;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Lock;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Unlock
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Unlock.class);
    private static final String OPERATION_NAME = "unlock";
    private static final String TARGET_KEY = "target";

    public Unlock(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        Datastore targetDatastore = Lock.extractTargetParameter(operationElement);
        if (targetDatastore == Datastore.candidate) {
            LOG.debug("Unlocking candidate datastore on session: {}", (Object)this.getNetconfSessionIdForReporting());
            return XmlUtil.createElement((Document)document, (String)"ok", (Optional)Optional.absent());
        }
        throw new NetconfDocumentedException("Unable to unlock " + (Object)((Object)targetDatastore) + " datastore", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

