/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops.get;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.controller.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlCodecProvider;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.DomUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.transform.dom.parser.DomToNormalizedNodeParserFactory;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractGet
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGet.class);
    protected static final String FILTER = "filter";
    static final YangInstanceIdentifier ROOT = YangInstanceIdentifier.builder().build();
    protected final CurrentSchemaContext schemaContext;
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private static final Function<YangInstanceIdentifier.PathArgument, QName> PATH_ARG_TO_QNAME;

    public AbstractGet(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
    }

    protected Node transformNormalizedNode(Document document, NormalizedNode<?, ?> data, YangInstanceIdentifier dataRoot) {
        DOMResult result = new DOMResult(document.createElement("data"));
        XMLStreamWriter xmlWriter = this.getXmlStreamWriter(result);
        NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)this.schemaContext.getCurrentContext(), (SchemaPath)this.getSchemaPath(dataRoot));
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter, (boolean)true);
        this.writeRootElement(xmlWriter, nnWriter, (ContainerNode)data);
        return result.getNode();
    }

    private XMLStreamWriter getXmlStreamWriter(DOMResult result) {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private SchemaPath getSchemaPath(YangInstanceIdentifier dataRoot) {
        return SchemaPath.create((Iterable)Iterables.transform((Iterable)dataRoot.getPathArguments(), PATH_ARG_TO_QNAME), (boolean)dataRoot.equals((Object)ROOT));
    }

    private void writeRootElement(XMLStreamWriter xmlWriter, NormalizedNodeWriter nnWriter, ContainerNode data) {
        try {
            if (data.getNodeType().equals((Object)SchemaContext.NAME)) {
                for (DataContainerChild child : data.getValue()) {
                    nnWriter.write((NormalizedNode)child);
                }
            } else {
                nnWriter.write((NormalizedNode)data);
            }
            nnWriter.flush();
            xmlWriter.flush();
        }
        catch (IOException | XMLStreamException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private DataSchemaNode getSchemaNodeFromNamespace(XmlElement element) throws NetconfDocumentedException {
        try {
            Module module = this.schemaContext.getCurrentContext().findModuleByNamespaceAndRevision(new URI(element.getNamespace()), null);
            DataSchemaNode dataSchemaNode = module.getDataChildByName(element.getName());
            if (dataSchemaNode != null) {
                return dataSchemaNode;
            }
        }
        catch (URISyntaxException e) {
            LOG.debug("Error during parsing of element namespace, this should not happen since namespace of an xml element is valid and if the xml was parsed then the URI should be as well");
            throw new IllegalArgumentException("Unable to parse element namespace, this should not happen since namespace of an xml element is valid and if the xml was parsed then the URI should be as well");
        }
        throw new NetconfDocumentedException("Unable to find node with namespace: " + element.getNamespace() + "in schema context: " + this.schemaContext.getCurrentContext().toString(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.unknown_namespace, NetconfDocumentedException.ErrorSeverity.error);
    }

    protected Element serializeNodeWithParentStructure(Document document, YangInstanceIdentifier dataRoot, NormalizedNode node) {
        if (!dataRoot.equals((Object)ROOT)) {
            return (Element)this.transformNormalizedNode(document, ImmutableNodes.fromInstanceId((SchemaContext)this.schemaContext.getCurrentContext(), (YangInstanceIdentifier)dataRoot, (NormalizedNode)node), ROOT);
        }
        return (Element)this.transformNormalizedNode(document, node, ROOT);
    }

    protected Optional<YangInstanceIdentifier> getDataRootFromFilter(XmlElement operationElement) throws NetconfDocumentedException {
        Optional filterElement = operationElement.getOnlyChildElementOptionally(FILTER);
        if (filterElement.isPresent()) {
            if (((XmlElement)filterElement.get()).getChildElements().size() == 0) {
                return Optional.absent();
            }
            return Optional.of((Object)this.getInstanceIdentifierFromFilter((XmlElement)filterElement.get()));
        }
        return Optional.of((Object)ROOT);
    }

    @VisibleForTesting
    protected YangInstanceIdentifier getInstanceIdentifierFromFilter(XmlElement filterElement) throws NetconfDocumentedException {
        if (filterElement.getChildElements().size() != 1) {
            throw new NetconfDocumentedException("Multiple filter roots not supported yet", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error);
        }
        XmlElement element = filterElement.getOnlyChildElement();
        DataSchemaNode schemaNode = this.getSchemaNodeFromNamespace(element);
        return this.getReadPointFromNode(YangInstanceIdentifier.builder().build(), this.filterToNormalizedNode(element, schemaNode));
    }

    private YangInstanceIdentifier getReadPointFromNode(YangInstanceIdentifier pathArg, NormalizedNode nNode) {
        DataContainerNode node;
        YangInstanceIdentifier path = pathArg.node(nNode.getIdentifier());
        if (nNode instanceof DataContainerNode && (node = (DataContainerNode)nNode).getValue().size() == 1) {
            return this.getReadPointFromNode(path, (NormalizedNode)Lists.newArrayList((Iterable)node.getValue()).get(0));
        }
        return path;
    }

    private NormalizedNode filterToNormalizedNode(XmlElement element, DataSchemaNode schemaNode) throws NetconfDocumentedException {
        NormalizedNode parsedNode;
        DomToNormalizedNodeParserFactory parserFactory = DomToNormalizedNodeParserFactory.getInstance((XmlCodecProvider)DomUtils.defaultValueCodecProvider(), (SchemaContext)this.schemaContext.getCurrentContext());
        if (schemaNode instanceof ContainerSchemaNode) {
            parsedNode = parserFactory.getContainerNodeParser().parse(Collections.singletonList(element.getDomElement()), (Object)((ContainerSchemaNode)schemaNode));
        } else if (schemaNode instanceof ListSchemaNode) {
            parsedNode = parserFactory.getMapNodeParser().parse(Collections.singletonList(element.getDomElement()), (Object)((ListSchemaNode)schemaNode));
        } else {
            throw new NetconfDocumentedException("Schema node of the top level element is not an instance of container or list", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.unknown_element, NetconfDocumentedException.ErrorSeverity.error);
        }
        return parsedNode;
    }

    static {
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        PATH_ARG_TO_QNAME = new Function<YangInstanceIdentifier.PathArgument, QName>(){

            public QName apply(YangInstanceIdentifier.PathArgument input) {
                return input.getNodeType();
            }
        };
    }

    protected static final class GetConfigExecution {
        private final Optional<Datastore> datastore;

        public GetConfigExecution(Optional<Datastore> datastore) {
            this.datastore = datastore;
        }

        public Optional<Datastore> getDatastore() {
            return this.datastore;
        }

        static GetConfigExecution fromXml(XmlElement xml, String operationName) throws NetconfDocumentedException {
            Optional<Datastore> sourceDatastore;
            try {
                GetConfigExecution.validateInputRpc(xml, operationName);
            }
            catch (NetconfDocumentedException e) {
                throw new NetconfDocumentedException("Incorrect RPC: " + e.getMessage(), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            try {
                sourceDatastore = GetConfigExecution.parseSource(xml);
            }
            catch (NetconfDocumentedException e) {
                throw new NetconfDocumentedException("Get-config source attribute error: " + e.getMessage(), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            return new GetConfigExecution(sourceDatastore);
        }

        private static Optional<Datastore> parseSource(XmlElement xml) throws NetconfDocumentedException {
            Optional sourceElement = xml.getOnlyChildElementOptionally("source", "urn:ietf:params:xml:ns:netconf:base:1.0");
            return sourceElement.isPresent() ? Optional.of((Object)((Object)Datastore.valueOf(((XmlElement)sourceElement.get()).getOnlyChildElement().getName()))) : Optional.absent();
        }

        private static void validateInputRpc(XmlElement xml, String operationName) throws NetconfDocumentedException {
            xml.checkName(operationName);
            xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        }
    }
}

