/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mdsal.connector.ops.get;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.controller.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.controller.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.controller.netconf.mdsal.connector.ops.get.AbstractGet;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetConfig
extends AbstractGet {
    private static final Logger LOG = LoggerFactory.getLogger(GetConfig.class);
    private static final String OPERATION_NAME = "get-config";
    private final TransactionProvider transactionProvider;

    public GetConfig(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting, schemaContext);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws NetconfDocumentedException {
        AbstractGet.GetConfigExecution getConfigExecution = null;
        try {
            getConfigExecution = AbstractGet.GetConfigExecution.fromXml(operationElement, OPERATION_NAME);
        }
        catch (NetconfDocumentedException e) {
            LOG.warn("Get request processing failed on session: {}", (Object)this.getNetconfSessionIdForReporting(), (Object)e);
            throw e;
        }
        Optional<YangInstanceIdentifier> dataRootOptional = this.getDataRootFromFilter(operationElement);
        if (!dataRootOptional.isPresent()) {
            return XmlUtil.createElement((Document)document, (String)"data", (Optional)Optional.absent());
        }
        YangInstanceIdentifier dataRoot = (YangInstanceIdentifier)dataRootOptional.get();
        Preconditions.checkState((boolean)getConfigExecution.getDatastore().isPresent(), (Object)"Source element missing from request");
        DOMDataReadWriteTransaction rwTx = this.getTransaction((Datastore)((Object)getConfigExecution.getDatastore().get()));
        try {
            Optional normalizedNodeOptional = (Optional)rwTx.read(LogicalDatastoreType.CONFIGURATION, dataRoot).checkedGet();
            if (getConfigExecution.getDatastore().get() == Datastore.running) {
                this.transactionProvider.abortRunningTransaction(rwTx);
            }
            if (!normalizedNodeOptional.isPresent()) {
                return XmlUtil.createElement((Document)document, (String)"data", (Optional)Optional.absent());
            }
            return this.serializeNodeWithParentStructure(document, dataRoot, (NormalizedNode)normalizedNodeOptional.get());
        }
        catch (ReadFailedException e) {
            LOG.warn("Unable to read data: {}", (Object)dataRoot, (Object)e);
            throw new IllegalStateException("Unable to read data " + dataRoot, e);
        }
    }

    private DOMDataReadWriteTransaction getTransaction(Datastore datastore) throws NetconfDocumentedException {
        if (datastore == Datastore.candidate) {
            return this.transactionProvider.getOrCreateTransaction();
        }
        if (datastore == Datastore.running) {
            return this.transactionProvider.createRunningTransaction();
        }
        throw new NetconfDocumentedException("Incorrect Datastore: ", NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.bad_element, NetconfDocumentedException.ErrorSeverity.error);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

