package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>mdsaltrace</b>
 * <pre>
 * container config {
 *   leaf-list registration-watches {
 *     type string;
 *   }
 *   leaf-list write-watches {
 *     type string;
 *   }
 *   leaf transaction-debug-context-enabled {
 *     default false;
 *     type boolean;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>mdsaltrace/config</i>
 *
 * <p>To create instances of this class use {@link ConfigBuilder}.
 * @see ConfigBuilder
 *
 */
public interface Config
    extends
    ChildOf<MdsaltraceData>,
    Augmentable<Config>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>registrationWatches</code>, or <code>null</code> if not present
     */
    @Nullable List<String> getRegistrationWatches();
    
    /**
     * @return <code>java.util.List</code> <code>writeWatches</code>, or <code>null</code> if not present
     */
    @Nullable List<String> getWriteWatches();
    
    /**
     * Enable or disable transaction context debug. This will preserve the call site 
     * trace for transactions, so that the original caller of un-close'd() transaction 
     * can be identified. NB: This is a different property from the equally named one 
     * in etc/org.opendaylight.controller.cluster.datastore.cfg; that one does 
     * something somewhat similar, but serves to include the stack trace on failed 
     * transaction submit, whereas this one is specific to odl-mdsal-trace's 
     * trace:transaction leak troubleshooting command.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>transactionDebugContextEnabled</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isTransactionDebugContextEnabled();

}

