package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>mdsaltrace</b>
 * <pre>
 * container config {
 *     leaf-list registration-watches {
 *         type string;
 *     }
 *     leaf-list write-watches {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>mdsaltrace/config</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.ConfigBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.ConfigBuilder
 *
 */
public interface Config
    extends
    ChildOf<MdsaltraceData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:mdsaltrace",
        "2016-09-08", "config").intern();

    /**
     * @return <code>java.util.List</code> <code>registrationWatches</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getRegistrationWatches();
    
    /**
     * @return <code>java.util.List</code> <code>writeWatches</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getWriteWatches();

}

