/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private List<String> _registrationWatches;
    private List<String> _writeWatches;
    private Boolean _transactionDebugContextEnabled;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(Config base) {
        AugmentationHolder casted;
        this._registrationWatches = base.getRegistrationWatches();
        this._writeWatches = base.getWriteWatches();
        this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
        if (base instanceof ConfigImpl) {
            ConfigImpl impl = (ConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(casted.augmentations());
        }
    }

    public List<String> getRegistrationWatches() {
        return this._registrationWatches;
    }

    public List<String> getWriteWatches() {
        return this._writeWatches;
    }

    public Boolean isTransactionDebugContextEnabled() {
        return this._transactionDebugContextEnabled;
    }

    public <E extends Augmentation<Config>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ConfigBuilder setRegistrationWatches(List<String> value) {
        this._registrationWatches = value;
        return this;
    }

    public ConfigBuilder setWriteWatches(List<String> value) {
        this._writeWatches = value;
        return this;
    }

    public ConfigBuilder setTransactionDebugContextEnabled(Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Class<? extends Augmentation<Config>> augmentationType, Augmentation<Config> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    implements Config {
        private final List<String> _registrationWatches;
        private final List<String> _writeWatches;
        private final Boolean _transactionDebugContextEnabled;
        private Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Config> getImplementedInterface() {
            return Config.class;
        }

        private ConfigImpl(ConfigBuilder base) {
            this._registrationWatches = base.getRegistrationWatches();
            this._writeWatches = base.getWriteWatches();
            this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Config>>, Augmentation<Config>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(base.augmentation);
                }
            }
        }

        @Override
        public List<String> getRegistrationWatches() {
            return this._registrationWatches;
        }

        @Override
        public List<String> getWriteWatches() {
            return this._writeWatches;
        }

        @Override
        public Boolean isTransactionDebugContextEnabled() {
            return this._transactionDebugContextEnabled;
        }

        public <E extends Augmentation<Config>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._registrationWatches);
            result = 31 * result + Objects.hashCode(this._writeWatches);
            result = 31 * result + Objects.hashCode(this._transactionDebugContextEnabled);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Config.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Config other = (Config)obj;
            if (!Objects.equals(this._registrationWatches, other.getRegistrationWatches())) {
                return false;
            }
            if (!Objects.equals(this._writeWatches, other.getWriteWatches())) {
                return false;
            }
            if (!Objects.equals(this._transactionDebugContextEnabled, other.isTransactionDebugContextEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConfigImpl otherImpl = (ConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Config>>, Augmentation<Config>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Config [";
            StringBuilder builder = new StringBuilder(name);
            if (this._registrationWatches != null) {
                builder.append("_registrationWatches=");
                builder.append(this._registrationWatches);
                builder.append(", ");
            }
            if (this._writeWatches != null) {
                builder.append("_writeWatches=");
                builder.append(this._writeWatches);
                builder.append(", ");
            }
            if (this._transactionDebugContextEnabled != null) {
                builder.append("_transactionDebugContextEnabled=");
                builder.append(this._transactionDebugContextEnabled);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

