/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.dom.impl;

import java.util.Objects;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.AbstractCloseTracked;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistry;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingBroker;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingReadOnlyTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingReadWriteTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingWriteTransaction;

class TracingTransactionChain
extends AbstractCloseTracked<TracingTransactionChain>
implements DOMTransactionChain {
    private final DOMTransactionChain delegate;
    private final TracingBroker tracingBroker;
    private final CloseTrackedRegistry<TracingReadOnlyTransaction> readOnlyTransactionsRegistry;
    private final CloseTrackedRegistry<TracingWriteTransaction> writeTransactionsRegistry;
    private final CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry;

    TracingTransactionChain(DOMTransactionChain delegate, TracingBroker tracingBroker, CloseTrackedRegistry<TracingTransactionChain> transactionChainsRegistry) {
        super(transactionChainsRegistry);
        this.delegate = Objects.requireNonNull(delegate);
        this.tracingBroker = Objects.requireNonNull(tracingBroker);
        boolean isDebug = transactionChainsRegistry.isDebugContextEnabled();
        String anchor = "TransactionChain@" + Integer.toHexString(this.hashCode());
        this.readOnlyTransactionsRegistry = new CloseTrackedRegistry(anchor, "newReadOnlyTransaction()", isDebug);
        this.writeTransactionsRegistry = new CloseTrackedRegistry(anchor, "newWriteOnlyTransaction()", isDebug);
        this.readWriteTransactionsRegistry = new CloseTrackedRegistry(anchor, "newReadWriteTransaction()", isDebug);
    }

    public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        DOMDataReadOnlyTransaction tx = this.delegate.newReadOnlyTransaction();
        return new TracingReadOnlyTransaction(tx, this.readOnlyTransactionsRegistry);
    }

    public DOMDataReadWriteTransaction newReadWriteTransaction() {
        return new TracingReadWriteTransaction(this.delegate.newReadWriteTransaction(), this.tracingBroker, this.readWriteTransactionsRegistry);
    }

    public DOMDataWriteTransaction newWriteOnlyTransaction() {
        DOMDataWriteTransaction tx = this.delegate.newWriteOnlyTransaction();
        return new TracingWriteTransaction(tx, this.tracingBroker, this.writeTransactionsRegistry);
    }

    public void close() {
        this.delegate.close();
        super.removeFromTrackedRegistry();
    }

    public CloseTrackedRegistry<TracingReadOnlyTransaction> getReadOnlyTransactionsRegistry() {
        return this.readOnlyTransactionsRegistry;
    }

    public CloseTrackedRegistry<TracingReadWriteTransaction> getReadWriteTransactionsRegistry() {
        return this.readWriteTransactionsRegistry;
    }

    public CloseTrackedRegistry<TracingWriteTransaction> getWriteTransactionsRegistry() {
        return this.writeTransactionsRegistry;
    }

    public final boolean equals(Object object) {
        return object == this || this.delegate.equals(object);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "; delegate=" + this.delegate;
    }
}

