/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicNotification;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.topic.notification.Payload;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TopicNotificationBuilder
implements Builder<TopicNotification> {
    private String _nodeId;
    private Payload _payload;
    private TopicId _topicId;
    Map<Class<? extends Augmentation<TopicNotification>>, Augmentation<TopicNotification>> augmentation = Collections.emptyMap();

    public TopicNotificationBuilder() {
    }

    public TopicNotificationBuilder(TopicNotification base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TopicNotification>>, Augmentation<TopicNotification>>(aug);
        }
        this._nodeId = base.getNodeId();
        this._payload = base.getPayload();
        this._topicId = base.getTopicId();
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public TopicId getTopicId() {
        return this._topicId;
    }

    public <E$$ extends Augmentation<TopicNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TopicNotificationBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public TopicNotificationBuilder setPayload(Payload value) {
        this._payload = value;
        return this;
    }

    public TopicNotificationBuilder setTopicId(TopicId value) {
        this._topicId = value;
        return this;
    }

    public TopicNotificationBuilder addAugmentation(Class<? extends Augmentation<TopicNotification>> augmentationType, Augmentation<TopicNotification> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TopicNotification>>, Augmentation<TopicNotification>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TopicNotificationBuilder removeAugmentation(Class<? extends Augmentation<TopicNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TopicNotification build() {
        return new TopicNotificationImpl(this);
    }

    private static final class TopicNotificationImpl
    extends AbstractAugmentable<TopicNotification>
    implements TopicNotification {
        private final String _nodeId;
        private final Payload _payload;
        private final TopicId _topicId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TopicNotificationImpl(TopicNotificationBuilder base) {
            super(base.augmentation);
            this._nodeId = base.getNodeId();
            this._payload = base.getPayload();
            this._topicId = base.getTopicId();
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public Payload getPayload() {
            return this._payload;
        }

        @Override
        public TopicId getTopicId() {
            return this._topicId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._payload);
            result = 31 * result + Objects.hashCode(this._topicId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TopicNotification.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            TopicNotification other = (TopicNotification)obj;
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._payload, other.getPayload())) {
                return false;
            }
            if (!Objects.equals(this._topicId, other.getTopicId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TopicNotificationImpl otherImpl = (TopicNotificationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TopicNotification");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeId", (Object)this._nodeId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_payload", (Object)this._payload);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topicId", (Object)this._topicId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

