package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>event-aggregator</b>
 * <pre>
 * container input {
 *     leaf notification-pattern {
 *         type notification-pattern;
 *     }
 *     leaf node-id-pattern {
 *         type pattern;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>event-aggregator/create-topic/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicInputBuilder
 *
 */
public interface CreateTopicInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:cisco:params:xml:ns:yang:messagebus:eventaggregator",
        "2014-12-02", "input").intern();

    /**
     * Pattern matching notification which should be forwarded into this topic.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern</code> <code>notificationPattern</code>, or <code>null</code> if not present
     */
    NotificationPattern getNotificationPattern();
    
    /**
     * Pattern for matching candidate event source nodes when looking for contributors 
     * to the topic. The pattern will be applied against 
     * /network-topology/topology/node/node-id
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.Pattern</code> <code>nodeIdPattern</code>, or <code>null</code> if not present
     */
    Pattern getNodeIdPattern();

}

