package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import com.google.common.base.Preconditions;


/**
 * Pattern for matching candidate notification types. This pattern is to be
 *             applied against the concatenation of the namespace of the module which
 *             defines that particular notification, followed by a single colon, and
 *             then followed by notification identifier, as supplied in the argument to
 *             the notification statement.
 *
 */
public class NotificationPattern extends Pattern
 implements Serializable {
    private static final long serialVersionUID = -1697464026883279240L;


    @ConstructorProperties("value")
    public NotificationPattern(java.lang.String _value) {
        super(_value);
    
    
        Preconditions.checkNotNull(_value, "Supplied value may not be null");
    
    
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NotificationPattern(NotificationPattern source) {
        super(source);
    }
    /**
     * Creates a new instance from Pattern
     *
     * @param source Source object
     */
    public NotificationPattern(Pattern source) {
            super(source);
    }

    public static NotificationPattern getDefaultInstance(String defaultValue) {
        return new NotificationPattern(defaultValue);
    }





}

