package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>event-source</b>
 * <pre>
 * container input {
 *     leaf node {
 *         type instance-identifier;
 *     }
 *     leaf topic-id {
 *         type topic-id;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>event-source/dis-join-topic/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInputBuilder
 *
 */
public interface DisJoinTopicInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:cisco:params:xml:ns:yang:messagebus:eventsource",
        "2014-12-02", "input").intern();

    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>node</code>, or <code>null</code> if not present
     */
    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContext.class
    )
    InstanceIdentifier<?> getNode();
    
    /**
     * identifier of topic to be disjoin
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId</code> <code>topicId</code>, or <code>null</code> if not present
     */
    TopicId getTopicId();

}

