package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>event-source</b>
 * <pre>
 * rpc join-topic {
 *     input {
 *         leaf node {
 *             type instance-identifier;
 *         }
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *         leaf notification-pattern {
 *             type notification-pattern;
 *         }
 *     }
 *     
 *     output {
 *         leaf status {
 *             type join-topic-status;
 *         }
 *     }
 * }
 * rpc dis-join-topic {
 *     input {
 *         leaf node {
 *             type instance-identifier;
 *         }
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *     }
 *     
 * }
 * </pre>
 *
 */
public interface EventSourceService
    extends
    RpcService
{




    Future<RpcResult<JoinTopicOutput>> joinTopic(JoinTopicInput input);
    
    Future<RpcResult<java.lang.Void>> disJoinTopic(DisJoinTopicInput input);

}

