package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import java.util.Objects;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1
 *
 */
public class Node1Builder implements Builder <org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1> {

    private NodeId _eventSourceNode;


    public Node1Builder() {
    }

    public Node1Builder(Node1 base) {
        this._eventSourceNode = base.getEventSourceNode();
    }


    public NodeId getEventSourceNode() {
        return _eventSourceNode;
    }

     
    public Node1Builder setEventSourceNode(final NodeId value) {
        this._eventSourceNode = value;
        return this;
    }

    public Node1 build() {
        return new Node1Impl(this);
    }

    private static final class Node1Impl implements Node1 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1.class;
        }

        private final NodeId _eventSourceNode;


        private Node1Impl(Node1Builder base) {
            this._eventSourceNode = base.getEventSourceNode();
        }

        @Override
        public NodeId getEventSourceNode() {
            return _eventSourceNode;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eventSourceNode);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1 other = (org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1)obj;
            if (!Objects.equals(_eventSourceNode, other.getEventSourceNode())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Node1 [");
            boolean first = true;
        
            if (_eventSourceNode != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eventSourceNode=");
                builder.append(_eventSourceNode);
             }
            return builder.append(']').toString();
        }
    }

}
