package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>event-aggregator</b>
 * <pre>
 * notification topic-notification {
 *     description
 *         "Notification of an event occuring on a particular node. This notification
 *         acts as an encapsulation for the event being delivered.";
 *     leaf topic-id {
 *         type topic-id;
 *     }
 *     leaf node-id {
 *         type string;
 *     }
 *     anyxml payload;
 * }
 * </pre>
 *
 */
public interface EventAggregatorListener
    extends
    NotificationListener
{




    /**
     * Notification of an event occuring on a particular node. This notificationacts as
     * an encapsulation for the event being delivered.
     *
     */
    void onTopicNotification(TopicNotification notification);

}

