package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;
import javax.annotation.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>event-aggregator</b>
 * <pre>
 * rpc destroy-topic {
 *     "Destroy a topic. No further messages will be delivered to it.";
 *     input {
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * rpc create-topic {
 *     "Create a new topic. A topic is an aggregation of several notification
 *     types from a set of nodes. Each successful invocation results in a unique
 *     topic being created. The caller is responsible for removing the topic
 *     once it is no longer needed.";
 *     input {
 *         leaf notification-pattern {
 *             type notification-pattern;
 *         }
 *         leaf node-id-pattern {
 *             type pattern;
 *         }
 *     }
 *     
 *     output {
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface EventAggregatorService
    extends
    RpcService
{




    /**
     * Destroy a topic. No further messages will be delivered to it.
     *
     */
    @CheckReturnValue
    Future<RpcResult<java.lang.Void>> destroyTopic(DestroyTopicInput input);
    
    /**
     * Create a new topic. A topic is an aggregation of several notificationtypes from 
     * a set of nodes. Each successful invocation results in a uniquetopic being 
     * created. The caller is responsible for removing the topiconce it is no longer 
     * needed.
     *
     */
    @CheckReturnValue
    Future<RpcResult<CreateTopicOutput>> createTopic(CreateTopicInput input);

}

