package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Notification of an event occuring on a particular node. This notificationacts 
 * an encapsulation for the event being delivered.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>event-aggregator</b>
 * <pre>
 * notification topic-notification {
 *     description
 *         "Notification of an event occuring on a particular node. This notification
 *         acts as an encapsulation for the event being delivered.";
 *     leaf topic-id {
 *         type topic-id;
 *     }
 *     leaf node-id {
 *         type string;
 *     }
 *     anyxml payload;
 * }
 * </pre>The schema path to identify an instance is
 * <i>event-aggregator/topic-notification</i>
 *
 * <p>To create instances of this class use {@link TopicNotificationBuilder}.
 * @see TopicNotificationBuilder
 *
 */
public interface TopicNotification
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicNotification>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:cisco:params:xml:ns:yang:messagebus:eventaggregator",
        "2014-12-02", "topic-notification").intern();

    /**
     * Topic to which this event is being delivered.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId</code> <code>topicId</code>, or <code>null</code> if not present
     */
    TopicId getTopicId();
    
    /**
     * Node ID of the node which generated the event.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>nodeId</code>, or <code>null</code> if not present
     */
    java.lang.String getNodeId();

}

