package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202;
import javax.annotation.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>event-source</b>
 * <pre>
 * rpc dis-join-topic {
 *     input {
 *         leaf node {
 *             type instance-identifier;
 *         }
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * rpc join-topic {
 *     input {
 *         leaf node {
 *             type instance-identifier;
 *         }
 *         leaf topic-id {
 *             type topic-id;
 *         }
 *         leaf notification-pattern {
 *             type notification-pattern;
 *         }
 *     }
 *     
 *     output {
 *         leaf status {
 *             type join-topic-status;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface EventSourceService
    extends
    RpcService
{




    @CheckReturnValue
    Future<RpcResult<java.lang.Void>> disJoinTopic(DisJoinTopicInput input);
    
    @CheckReturnValue
    Future<RpcResult<JoinTopicOutput>> joinTopic(JoinTopicInput input);

}

