package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>event-source</b>
 * <pre>
 * container output {
 *     leaf status {
 *         type join-topic-status;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>event-source/join-topic/output</i>
 *
 * <p>To create instances of this class use {@link JoinTopicOutputBuilder}.
 * @see JoinTopicOutputBuilder
 *
 */
public interface JoinTopicOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:cisco:params:xml:ns:yang:messagebus:eventsource",
        "2014-12-02", "output").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicStatus</code> <code>status</code>, or <code>null</code> if not present
     */
    JoinTopicStatus getStatus();

}

