/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.app.impl;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.opendaylight.controller.messagebus.app.impl.EventSourceTopology;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public final class EventSourceTopic
implements DataTreeChangeListener<Node>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceTopic.class);
    private final CopyOnWriteArraySet<InstanceIdentifier<?>> joinedEventSources = new CopyOnWriteArraySet();
    private final NotificationPattern notificationPattern;
    private final EventSourceService sourceService;
    private final Pattern nodeIdPattern;
    private final TopicId topicId;
    private ListenerRegistration<?> listenerRegistration;

    public static EventSourceTopic create(NotificationPattern notificationPattern, String nodeIdRegexPattern, EventSourceTopology eventSourceTopology) {
        EventSourceTopic est = new EventSourceTopic(notificationPattern, nodeIdRegexPattern, eventSourceTopology.getEventSourceService());
        est.registerListner(eventSourceTopology);
        est.notifyExistingNodes(eventSourceTopology);
        return est;
    }

    private EventSourceTopic(NotificationPattern notificationPattern, String nodeIdRegexPattern, EventSourceService sourceService) {
        this.notificationPattern = Objects.requireNonNull(notificationPattern);
        this.sourceService = Objects.requireNonNull(sourceService);
        this.nodeIdPattern = Pattern.compile(nodeIdRegexPattern);
        this.topicId = new TopicId(EventSourceTopic.getUUIDIdent());
        this.listenerRegistration = null;
        LOG.info("EventSourceTopic created - topicId {}", (Object)this.topicId.getValue());
    }

    public TopicId getTopicId() {
        return this.topicId;
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Node>> changes) {
        for (DataTreeModification<Node> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            switch (rootNode.getModificationType()) {
                case WRITE: 
                case SUBTREE_MODIFIED: {
                    Node node = (Node)rootNode.getDataAfter();
                    if (!this.getNodeIdRegexPattern().matcher(node.getNodeId().getValue()).matches()) break;
                    this.notifyNode(change.getRootPath().getRootIdentifier());
                    break;
                }
            }
        }
    }

    public void notifyNode(InstanceIdentifier<?> nodeId) {
        LOG.debug("Notify node: {}", nodeId);
        try {
            RpcResult rpcResultJoinTopic = (RpcResult)this.sourceService.joinTopic(this.getJoinTopicInputArgument(nodeId)).get();
            if (!rpcResultJoinTopic.isSuccessful()) {
                for (RpcError err : rpcResultJoinTopic.getErrors()) {
                    LOG.error("Can not join topic: [{}] on node: [{}]. Error: {}", new Object[]{this.getTopicId().getValue(), nodeId.toString(), err.toString()});
                }
            } else {
                this.joinedEventSources.add(nodeId);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Could not invoke join topic for node {}", nodeId);
        }
    }

    private void notifyExistingNodes(EventSourceTopology eventSourceTopology) {
        FluentFuture future;
        LOG.debug("Notify existing nodes");
        final Pattern nodeRegex = this.nodeIdPattern;
        try (ReadTransaction tx = eventSourceTopology.getDataBroker().newReadOnlyTransaction();){
            future = tx.read(LogicalDatastoreType.OPERATIONAL, EventSourceTopology.EVENT_SOURCE_TOPOLOGY_PATH);
        }
        future.addCallback((FutureCallback)new FutureCallback<Optional<Topology>>(){

            public void onSuccess(Optional<Topology> data) {
                if (data.isPresent()) {
                    for (Node node : data.get().nonnullNode().values()) {
                        if (!nodeRegex.matcher(node.getNodeId().getValue()).matches()) continue;
                        EventSourceTopic.this.notifyNode((InstanceIdentifier<?>)EventSourceTopology.EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class, (Identifier)node.key()));
                    }
                }
            }

            public void onFailure(Throwable ex) {
                LOG.error("Can not notify existing nodes", ex);
            }
        }, MoreExecutors.directExecutor());
    }

    private JoinTopicInput getJoinTopicInputArgument(InstanceIdentifier<?> path) {
        NodeRef nodeRef = new NodeRef(path);
        JoinTopicInput jti = new JoinTopicInputBuilder().setNode(nodeRef.getValue()).setTopicId(this.topicId).setNotificationPattern(this.notificationPattern).build();
        return jti;
    }

    public Pattern getNodeIdRegexPattern() {
        return this.nodeIdPattern;
    }

    private DisJoinTopicInput getDisJoinTopicInputArgument(InstanceIdentifier<?> eventSourceNodeId) {
        NodeRef nodeRef = new NodeRef(eventSourceNodeId);
        DisJoinTopicInput dji = new DisJoinTopicInputBuilder().setNode(nodeRef.getValue()).setTopicId(this.topicId).build();
        return dji;
    }

    private void registerListner(EventSourceTopology eventSourceTopology) {
        this.listenerRegistration = eventSourceTopology.getDataBroker().registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)EventSourceTopology.EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class)), (DataTreeChangeListener)this);
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
        }
        for (InstanceIdentifier<?> eventSourceNodeId : this.joinedEventSources) {
            try {
                RpcResult result = (RpcResult)this.sourceService.disJoinTopic(this.getDisJoinTopicInputArgument(eventSourceNodeId)).get();
                if (result.isSuccessful()) continue;
                for (RpcError err : result.getErrors()) {
                    LOG.error("Can not destroy topic: [{}] on node: [{}]. Error: {}", new Object[]{this.getTopicId().getValue(), eventSourceNodeId, err.toString()});
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.error("Can not close event source topic / destroy topic {} on node {}.", new Object[]{this.topicId.getValue(), eventSourceNodeId, ex});
            }
        }
        this.joinedEventSources.clear();
    }

    private static String getUUIDIdent() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }
}

