/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.app.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.messagebus.app.impl.EventSourceRegistrationImpl;
import org.opendaylight.controller.messagebus.app.impl.EventSourceTopic;
import org.opendaylight.controller.messagebus.app.util.Util;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.DestroyTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.DestroyTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.DestroyTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.EventAggregatorService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1Builder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.TopologyTypes1;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.TopologyTypes1Builder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.topology.event.source.type.TopologyEventSource;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.topology.event.source.type.TopologyEventSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class EventSourceTopology
implements EventAggregatorService,
EventSourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceTopology.class);
    private static final String TOPOLOGY_ID = "EVENT-SOURCE-TOPOLOGY";
    private static final TopologyKey EVENT_SOURCE_TOPOLOGY_KEY = new TopologyKey(new TopologyId("EVENT-SOURCE-TOPOLOGY"));
    private static final LogicalDatastoreType OPERATIONAL = LogicalDatastoreType.OPERATIONAL;
    static final InstanceIdentifier<Topology> EVENT_SOURCE_TOPOLOGY_PATH = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)EVENT_SOURCE_TOPOLOGY_KEY);
    private static final InstanceIdentifier<TopologyTypes1> TOPOLOGY_TYPE_PATH = EVENT_SOURCE_TOPOLOGY_PATH.child(TopologyTypes.class).augmentation(TopologyTypes1.class);
    private final Map<TopicId, EventSourceTopic> eventSourceTopicMap = new ConcurrentHashMap<TopicId, EventSourceTopic>();
    private final Map<NodeKey, Registration> routedRpcRegistrations = new ConcurrentHashMap<NodeKey, Registration>();
    private final DataBroker dataBroker;
    private final ObjectRegistration<EventSourceTopology> aggregatorRpcReg;
    private final EventSourceService eventSourceService;
    private final RpcProviderService rpcRegistry;

    public EventSourceTopology(DataBroker dataBroker, RpcProviderService providerService, RpcConsumerRegistry rpcService) {
        this.dataBroker = dataBroker;
        this.rpcRegistry = providerService;
        this.aggregatorRpcReg = providerService.registerRpcImplementation(EventAggregatorService.class, (RpcService)this);
        this.eventSourceService = (EventSourceService)rpcService.getRpcService(EventSourceService.class);
        TopologyEventSource topologySource = new TopologyEventSourceBuilder().build();
        TopologyTypes1 topologyTypeAugment = new TopologyTypes1Builder().setTopologyEventSource(topologySource).build();
        this.putData(OPERATIONAL, TOPOLOGY_TYPE_PATH, topologyTypeAugment);
        LOG.info("EventSourceRegistry has been initialized");
    }

    private <T extends DataObject> void putData(final LogicalDatastoreType store, final InstanceIdentifier<T> path, T data) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.mergeParentStructurePut(store, path, data);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Data has put into datastore {} {}", (Object)store, (Object)path);
            }

            public void onFailure(Throwable ex) {
                LOG.error("Can not put data into datastore [store: {}] [path: {}]", new Object[]{store, path, ex});
            }
        }, MoreExecutors.directExecutor());
    }

    private <T extends DataObject> void deleteData(final LogicalDatastoreType store, final InstanceIdentifier<T> path) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.delete(OPERATIONAL, path);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Data has deleted from datastore {} {}", (Object)store, (Object)path);
            }

            public void onFailure(Throwable ex) {
                LOG.error("Can not delete data from datastore [store: {}] [path: {}]", new Object[]{store, path, ex});
            }
        }, MoreExecutors.directExecutor());
    }

    private void insert(KeyedInstanceIdentifier<Node, NodeKey> sourcePath) {
        NodeKey nodeKey = (NodeKey)sourcePath.getKey();
        InstanceIdentifier augmentPath = sourcePath.augmentation(Node1.class);
        Node1 nodeAgument = new Node1Builder().setEventSourceNode(new NodeId(nodeKey.getNodeId().getValue())).build();
        this.putData(OPERATIONAL, augmentPath, nodeAgument);
    }

    private void remove(KeyedInstanceIdentifier<Node, NodeKey> sourcePath) {
        InstanceIdentifier augmentPath = sourcePath.augmentation(Node1.class);
        this.deleteData(OPERATIONAL, augmentPath);
    }

    public ListenableFuture<RpcResult<CreateTopicOutput>> createTopic(CreateTopicInput input) {
        LOG.debug("Received Topic creation request: NotificationPattern -> {}, NodeIdPattern -> {}", (Object)input.getNotificationPattern(), (Object)input.getNodeIdPattern());
        NotificationPattern notificationPattern = new NotificationPattern(input.getNotificationPattern());
        String nodeIdPattern = input.getNodeIdPattern().getValue();
        EventSourceTopic eventSourceTopic = EventSourceTopic.create(notificationPattern, nodeIdPattern, this);
        this.eventSourceTopicMap.put(eventSourceTopic.getTopicId(), eventSourceTopic);
        CreateTopicOutput cto = new CreateTopicOutputBuilder().setTopicId(eventSourceTopic.getTopicId()).build();
        LOG.info("Topic has been created: NotificationPattern -> {}, NodeIdPattern -> {}", (Object)input.getNotificationPattern(), (Object)input.getNodeIdPattern());
        return Util.resultRpcSuccessFor((Object)cto);
    }

    public ListenableFuture<RpcResult<DestroyTopicOutput>> destroyTopic(DestroyTopicInput input) {
        EventSourceTopic topicToDestroy = this.eventSourceTopicMap.remove(input.getTopicId());
        if (topicToDestroy != null) {
            topicToDestroy.close();
        }
        return Util.resultRpcSuccessFor((Object)new DestroyTopicOutputBuilder().build());
    }

    public void close() {
        this.aggregatorRpcReg.close();
        this.eventSourceTopicMap.values().forEach(EventSourceTopic::close);
    }

    public void register(EventSource eventSource) {
        NodeKey nodeKey = eventSource.getSourceNodeKey();
        KeyedInstanceIdentifier sourcePath = EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class, (Identifier)nodeKey);
        ObjectRegistration reg = this.rpcRegistry.registerRpcImplementation(EventSourceService.class, (RpcService)eventSource, Collections.singleton(sourcePath));
        this.routedRpcRegistrations.put(nodeKey, (Registration)reg);
        this.insert((KeyedInstanceIdentifier<Node, NodeKey>)sourcePath);
    }

    public void unRegister(EventSource eventSource) {
        NodeKey nodeKey = eventSource.getSourceNodeKey();
        KeyedInstanceIdentifier sourcePath = EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class, (Identifier)nodeKey);
        Registration removeRegistration = this.routedRpcRegistrations.remove(nodeKey);
        if (removeRegistration != null) {
            removeRegistration.close();
            this.remove((KeyedInstanceIdentifier<Node, NodeKey>)sourcePath);
        }
    }

    public <T extends EventSource> EventSourceRegistration<T> registerEventSource(T eventSource) {
        EventSourceRegistrationImpl<T> esr = new EventSourceRegistrationImpl<T>(eventSource, this);
        this.register(eventSource);
        return esr;
    }

    DataBroker getDataBroker() {
        return this.dataBroker;
    }

    EventSourceService getEventSourceService() {
        return this.eventSourceService;
    }

    @VisibleForTesting
    Map<NodeKey, Registration> getRoutedRpcRegistrations() {
        return this.routedRpcRegistrations;
    }

    @VisibleForTesting
    Map<TopicId, EventSourceTopic> getEventSourceTopicMap() {
        return this.eventSourceTopicMap;
    }
}

