/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.nettyutil.handler.FramingMechanismHandlerFactory;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfEOMAggregator;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfHelloMessageToXMLEncoder;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfXMLToHelloMessageDecoder;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;

public abstract class AbstractChannelInitializer<S extends NetconfSession> {
    public static final String NETCONF_MESSAGE_DECODER = "netconfMessageDecoder";
    public static final String NETCONF_MESSAGE_AGGREGATOR = "aggregator";
    public static final String NETCONF_MESSAGE_ENCODER = "netconfMessageEncoder";
    public static final String NETCONF_MESSAGE_FRAME_ENCODER = "frameEncoder";
    public static final String NETCONF_SESSION_NEGOTIATOR = "negotiator";

    public void initialize(Channel ch, Promise<S> promise) {
        ch.pipeline().addLast(NETCONF_MESSAGE_AGGREGATOR, (ChannelHandler)new NetconfEOMAggregator());
        this.initializeMessageDecoder(ch);
        ch.pipeline().addLast(NETCONF_MESSAGE_FRAME_ENCODER, FramingMechanismHandlerFactory.createHandler(FramingMechanism.EOM));
        this.initializeMessageEncoder(ch);
        this.initializeSessionNegotiator(ch, promise);
    }

    protected void initializeMessageEncoder(Channel ch) {
        ch.pipeline().addLast(NETCONF_MESSAGE_ENCODER, (ChannelHandler)new NetconfHelloMessageToXMLEncoder());
    }

    protected void initializeMessageDecoder(Channel ch) {
        ch.pipeline().addLast(NETCONF_MESSAGE_DECODER, (ChannelHandler)new NetconfXMLToHelloMessageDecoder());
    }

    protected abstract void initializeSessionNegotiator(Channel var1, Promise<S> var2);
}

