/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.opendaylight.controller.netconf.api.NetconfExiSession;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.NetconfSessionListener;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfEXIToMessageDecoder;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfMessageToEXIEncoder;
import org.opendaylight.controller.netconf.nettyutil.handler.exi.EXIParameters;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.protocol.framework.AbstractProtocolSession;
import org.opendaylight.protocol.framework.TerminationReason;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.sax.TransmogrifierException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractNetconfSession<S extends NetconfSession, L extends NetconfSessionListener<S>>
extends AbstractProtocolSession<NetconfMessage>
implements NetconfSession,
NetconfExiSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfSession.class);
    private final L sessionListener;
    private final long sessionId;
    private boolean up = false;
    private ChannelHandler delayedEncoder;
    private final Channel channel;

    protected AbstractNetconfSession(L sessionListener, Channel channel, long sessionId) {
        this.sessionListener = sessionListener;
        this.channel = channel;
        this.sessionId = sessionId;
        LOG.debug("Session {} created", (Object)sessionId);
    }

    protected abstract S thisInstance();

    public void close() {
        this.channel.close();
        this.up = false;
        this.sessionListener.onSessionTerminated(this.thisInstance(), (TerminationReason)new NetconfTerminationReason("Session closed"));
    }

    protected void handleMessage(NetconfMessage netconfMessage) {
        LOG.debug("handling incoming message");
        this.sessionListener.onMessage(this.thisInstance(), (Object)netconfMessage);
    }

    public ChannelFuture sendMessage(NetconfMessage netconfMessage) {
        ChannelFuture future = this.channel.writeAndFlush((Object)netconfMessage);
        if (this.delayedEncoder != null) {
            this.replaceMessageEncoder(this.delayedEncoder);
            this.delayedEncoder = null;
        }
        return future;
    }

    protected void endOfInput() {
        LOG.debug("Session {} end of input detected while session was in state {}", (Object)this.toString(), (Object)(this.isUp() ? "up" : "initialized"));
        if (this.isUp()) {
            this.sessionListener.onSessionDown(this.thisInstance(), (Exception)new IOException("End of input detected. Close the session."));
        }
    }

    protected void sessionUp() {
        LOG.debug("Session {} up", (Object)this.toString());
        this.sessionListener.onSessionUp(this.thisInstance());
        this.up = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(((Object)((Object)this)).getClass().getSimpleName() + "{");
        sb.append("sessionId=").append(this.sessionId);
        sb.append(", channel=").append(this.channel);
        sb.append('}');
        return sb.toString();
    }

    protected final void replaceMessageDecoder(ChannelHandler handler) {
        this.replaceChannelHandler("netconfMessageDecoder", handler);
    }

    protected final void replaceMessageEncoder(ChannelHandler handler) {
        this.replaceChannelHandler("netconfMessageEncoder", handler);
    }

    protected final void replaceMessageEncoderAfterNextMessage(ChannelHandler handler) {
        this.delayedEncoder = handler;
    }

    protected final void replaceChannelHandler(String handlerName, ChannelHandler handler) {
        this.channel.pipeline().replace(handlerName, handlerName, handler);
    }

    public final void startExiCommunication(NetconfMessage startExiMessage) {
        NetconfEXIToMessageDecoder exiDecoder;
        NetconfMessageToEXIEncoder exiEncoder;
        EXIParameters exiParams;
        try {
            exiParams = EXIParameters.fromXmlElement(XmlElement.fromDomDocument((Document)startExiMessage.getDocument()));
        }
        catch (EXIOptionsException e) {
            LOG.warn("Unable to parse EXI parameters from {} on session {}", new Object[]{startExiMessage, this, e});
            throw new IllegalArgumentException("Cannot parse options", e);
        }
        NetconfEXICodec exiCodec = new NetconfEXICodec(exiParams.getOptions());
        try {
            exiEncoder = NetconfMessageToEXIEncoder.create(exiCodec);
        }
        catch (EXIOptionsException | TransmogrifierException e) {
            LOG.warn("Failed to instantiate EXI encoder for {} on session {}", new Object[]{exiCodec, this, e});
            throw new IllegalStateException("Cannot instantiate encoder for options", e);
        }
        try {
            exiDecoder = NetconfEXIToMessageDecoder.create(exiCodec);
        }
        catch (EXIOptionsException e) {
            LOG.warn("Failed to instantiate EXI decodeer for {} on session {}", new Object[]{exiCodec, this, e});
            throw new IllegalStateException("Cannot instantiate encoder for options", e);
        }
        this.addExiHandlers(exiDecoder, exiEncoder);
        LOG.debug("Session {} EXI handlers added to pipeline", (Object)this);
    }

    protected abstract void addExiHandlers(ByteToMessageDecoder var1, MessageToByteEncoder<NetconfMessage> var2);

    public final boolean isUp() {
        return this.up;
    }

    public final long getSessionId() {
        return this.sessionId;
    }
}

