/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSessionListener;
import org.opendaylight.controller.netconf.api.NetconfSessionPreferences;
import org.opendaylight.controller.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.controller.netconf.nettyutil.handler.FramingMechanismHandlerFactory;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfChunkAggregator;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfMessageToXMLEncoder;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfXMLToHelloMessageDecoder;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfXMLToMessageDecoder;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;
import org.opendaylight.controller.netconf.util.messages.NetconfHelloMessage;
import org.opendaylight.protocol.framework.AbstractSessionNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AbstractNetconfSessionNegotiator<P extends NetconfSessionPreferences, S extends AbstractNetconfSession<S, L>, L extends NetconfSessionListener<S>>
extends AbstractSessionNegotiator<NetconfHelloMessage, S> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfSessionNegotiator.class);
    public static final String NAME_OF_EXCEPTION_HANDLER = "lastExceptionHandler";
    protected final P sessionPreferences;
    private final L sessionListener;
    private Timeout timeout;
    private State state = State.IDLE;
    private final Promise<S> promise;
    private final Timer timer;
    private final long connectionTimeoutMillis;

    protected AbstractNetconfSessionNegotiator(P sessionPreferences, Promise<S> promise, Channel channel, Timer timer, L sessionListener, long connectionTimeoutMillis) {
        super(promise, channel);
        this.sessionPreferences = sessionPreferences;
        this.promise = promise;
        this.timer = timer;
        this.sessionListener = sessionListener;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    protected final void startNegotiation() {
        Optional<SslHandler> sslHandler = AbstractNetconfSessionNegotiator.getSslHandler(this.channel);
        if (sslHandler.isPresent()) {
            Future future = ((SslHandler)sslHandler.get()).handshakeFuture();
            future.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                public void operationComplete(Future<? super Channel> future) {
                    Preconditions.checkState((boolean)future.isSuccess(), (Object)"Ssl handshake was not successful");
                    LOG.debug("Ssl handshake complete");
                    AbstractNetconfSessionNegotiator.this.start();
                }
            });
        } else {
            this.start();
        }
    }

    private static Optional<SslHandler> getSslHandler(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        return sslHandler == null ? Optional.absent() : Optional.of((Object)sslHandler);
    }

    public P getSessionPreferences() {
        return this.sessionPreferences;
    }

    private void start() {
        NetconfMessage helloMessage = this.sessionPreferences.getHelloMessage();
        LOG.debug("Session negotiation started with hello message {} on channel {}", (Object)helloMessage, (Object)this.channel);
        this.channel.pipeline().addLast(NAME_OF_EXCEPTION_HANDLER, (ChannelHandler)new ExceptionHandlingInboundChannelHandler());
        this.sendMessage((NetconfHelloMessage)helloMessage);
        this.replaceHelloMessageOutboundHandler();
        this.changeState(State.OPEN_WAIT);
        this.timeout = this.timer.newTimeout(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (AbstractNetconfSessionNegotiator.this.state != State.ESTABLISHED) {
                        LOG.debug("Connection timeout after {}, session is in state {}", (Object)timeout, (Object)AbstractNetconfSessionNegotiator.this.state);
                        if (!this.isPromiseFinished()) {
                            AbstractNetconfSessionNegotiator.this.negotiationFailed(new IllegalStateException("Session was not established after " + timeout));
                            AbstractNetconfSessionNegotiator.this.changeState(State.FAILED);
                            AbstractNetconfSessionNegotiator.this.channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (future.isSuccess()) {
                                        LOG.debug("Channel {} closed: success", (Object)future.channel());
                                    } else {
                                        LOG.warn("Channel {} closed: fail", (Object)future.channel());
                                    }
                                }
                            });
                        }
                    } else if (AbstractNetconfSessionNegotiator.this.channel.isOpen()) {
                        AbstractNetconfSessionNegotiator.this.channel.pipeline().remove(AbstractNetconfSessionNegotiator.NAME_OF_EXCEPTION_HANDLER);
                    }
                }
            }

            private boolean isPromiseFinished() {
                return AbstractNetconfSessionNegotiator.this.promise.isDone() || AbstractNetconfSessionNegotiator.this.promise.isCancelled();
            }
        }, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelTimeout() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    protected final S getSessionForHelloMessage(NetconfHelloMessage netconfMessage) throws NetconfDocumentedException {
        Preconditions.checkNotNull((Object)netconfMessage, (Object)"netconfMessage");
        Document doc = netconfMessage.getDocument();
        if (this.shouldUseChunkFraming(doc)) {
            this.insertChunkFramingToPipeline();
        }
        this.changeState(State.ESTABLISHED);
        return this.getSession(this.sessionListener, this.channel, netconfMessage);
    }

    private void insertChunkFramingToPipeline() {
        AbstractNetconfSessionNegotiator.replaceChannelHandler(this.channel, "frameEncoder", FramingMechanismHandlerFactory.createHandler(FramingMechanism.CHUNK));
        AbstractNetconfSessionNegotiator.replaceChannelHandler(this.channel, "aggregator", (ChannelHandler)new NetconfChunkAggregator());
    }

    private boolean shouldUseChunkFraming(Document doc) {
        return AbstractNetconfSessionNegotiator.containsBase11Capability(doc) && AbstractNetconfSessionNegotiator.containsBase11Capability(this.sessionPreferences.getHelloMessage().getDocument());
    }

    protected final void replaceHelloMessageInboundHandler(S session) {
        ChannelHandler helloMessageHandler = AbstractNetconfSessionNegotiator.replaceChannelHandler(this.channel, "netconfMessageDecoder", (ChannelHandler)new NetconfXMLToMessageDecoder());
        Preconditions.checkState((boolean)(helloMessageHandler instanceof NetconfXMLToHelloMessageDecoder), (String)"Pipeline handlers misplaced on session: %s, pipeline: %s", (Object[])new Object[]{session, this.channel.pipeline()});
        Iterable<NetconfMessage> netconfMessagesFromNegotiation = ((NetconfXMLToHelloMessageDecoder)helloMessageHandler).getPostHelloNetconfMessages();
        for (NetconfMessage message : netconfMessagesFromNegotiation) {
            ((AbstractNetconfSession)((Object)session)).handleMessage(message);
        }
    }

    private void replaceHelloMessageOutboundHandler() {
        AbstractNetconfSessionNegotiator.replaceChannelHandler(this.channel, "netconfMessageEncoder", (ChannelHandler)new NetconfMessageToXMLEncoder());
    }

    private static ChannelHandler replaceChannelHandler(Channel channel, String handlerKey, ChannelHandler decoder) {
        return channel.pipeline().replace(handlerKey, handlerKey, decoder);
    }

    protected abstract S getSession(L var1, Channel var2, NetconfHelloMessage var3) throws NetconfDocumentedException;

    private synchronized void changeState(State newState) {
        LOG.debug("Changing state from : {} to : {} for channel: {}", new Object[]{this.state, newState, this.channel});
        Preconditions.checkState((boolean)AbstractNetconfSessionNegotiator.isStateChangePermitted(this.state, newState), (String)"Cannot change state from %s to %s for chanel %s", (Object[])new Object[]{this.state, newState, this.channel});
        this.state = newState;
    }

    private static boolean containsBase11Capability(Document doc) {
        NodeList nList = doc.getElementsByTagName("capability");
        for (int i = 0; i < nList.getLength(); ++i) {
            if (!nList.item(i).getTextContent().contains("urn:ietf:params:netconf:base:1.1")) continue;
            return true;
        }
        return false;
    }

    private static boolean isStateChangePermitted(State state, State newState) {
        if (state == State.IDLE && newState == State.OPEN_WAIT) {
            return true;
        }
        if (state == State.OPEN_WAIT && newState == State.ESTABLISHED) {
            return true;
        }
        if (state == State.OPEN_WAIT && newState == State.FAILED) {
            return true;
        }
        LOG.debug("Transition from {} to {} is not allowed", (Object)state, (Object)newState);
        return false;
    }

    private final class ExceptionHandlingInboundChannelHandler
    extends ChannelInboundHandlerAdapter {
        private ExceptionHandlingInboundChannelHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.warn("An exception occurred during negotiation with {}", (Object)AbstractNetconfSessionNegotiator.this.channel.remoteAddress(), (Object)cause);
            AbstractNetconfSessionNegotiator.this.cancelTimeout();
            AbstractNetconfSessionNegotiator.this.negotiationFailed(cause);
            AbstractNetconfSessionNegotiator.this.changeState(State.FAILED);
        }
    }

    protected static enum State {
        IDLE,
        OPEN_WAIT,
        FAILED,
        ESTABLISHED;

    }
}

