/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BufferedWriter
extends Writer {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private final Writer writer;
    private final char[] buffer;
    private final int bufferSize;
    private int nextChar = 0;

    public BufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public BufferedWriter(Writer writer, int bufferSize) {
        super((Object)writer);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Buffer size <= 0");
        this.writer = writer;
        this.buffer = new char[bufferSize];
        this.bufferSize = bufferSize;
    }

    private void flushBuffer() throws IOException {
        if (this.nextChar == 0) {
            return;
        }
        this.writer.write(this.buffer, 0, this.nextChar);
        this.nextChar = 0;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.nextChar >= this.bufferSize) {
            this.flushBuffer();
        }
        this.buffer[this.nextChar++] = (char)c;
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException(String.format("Buffer size: %d, Offset: %d, Length: %d", buffer.length, offset, length));
        }
        if (length == 0) {
            return;
        }
        if (length >= this.bufferSize) {
            this.flushBuffer();
            this.writer.write(buffer, offset, length);
            return;
        }
        int b = offset;
        int t = offset + length;
        while (b < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - b);
            System.arraycopy(buffer, b, this.buffer, this.nextChar, d);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.bufferSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void write(String string, int offset, int length) throws IOException {
        int b = offset;
        int t = offset + length;
        while (b < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - b);
            string.getChars(b, b + d, this.buffer, this.nextChar);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.bufferSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer();
        }
        finally {
            this.writer.close();
        }
    }
}

