/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.opendaylight.controller.netconf.util.messages.NetconfMessageConstants;

public class ChunkedFramingMechanismEncoder
extends MessageToByteEncoder<ByteBuf> {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    public static final int MIN_CHUNK_SIZE = 128;
    public static final int MAX_CHUNK_SIZE = 0x1000000;
    private final int chunkSize;

    public ChunkedFramingMechanismEncoder() {
        this(8192);
    }

    public ChunkedFramingMechanismEncoder(int chunkSize) {
        Preconditions.checkArgument((chunkSize >= 128 && chunkSize <= 0x1000000 ? 1 : 0) != 0, (String)"Unsupported chunk size %s", (Object[])new Object[]{chunkSize});
        this.chunkSize = chunkSize;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        do {
            int xfer = Math.min(this.chunkSize, msg.readableBytes());
            out.writeBytes(NetconfMessageConstants.START_OF_CHUNK);
            out.writeBytes(String.valueOf(xfer).getBytes(Charsets.US_ASCII));
            out.writeByte(10);
            out.writeBytes(msg, xfer);
        } while (msg.isReadable());
        out.writeBytes(NetconfMessageConstants.END_OF_CHUNK);
    }
}

